# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LlmSelection(object):
    """
    LLM selection configuration - either DEFAULT or CUSTOM.
    """

    #: A constant which can be used with the llm_selection_type property of a LlmSelection.
    #: This constant has a value of "DEFAULT"
    LLM_SELECTION_TYPE_DEFAULT = "DEFAULT"

    #: A constant which can be used with the llm_selection_type property of a LlmSelection.
    #: This constant has a value of "CUSTOM_GEN_AI_MODEL"
    LLM_SELECTION_TYPE_CUSTOM_GEN_AI_MODEL = "CUSTOM_GEN_AI_MODEL"

    #: A constant which can be used with the llm_selection_type property of a LlmSelection.
    #: This constant has a value of "CUSTOM_GEN_AI_ENDPOINT"
    LLM_SELECTION_TYPE_CUSTOM_GEN_AI_ENDPOINT = "CUSTOM_GEN_AI_ENDPOINT"

    def __init__(self, **kwargs):
        """
        Initializes a new LlmSelection object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_agent.models.DefaultLlmSelection`
        * :class:`~oci.generative_ai_agent.models.CustomGenAiEndpointLlmSelection`
        * :class:`~oci.generative_ai_agent.models.CustomGenAiModelLlmSelection`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param llm_selection_type:
            The value to assign to the llm_selection_type property of this LlmSelection.
            Allowed values for this property are: "DEFAULT", "CUSTOM_GEN_AI_MODEL", "CUSTOM_GEN_AI_ENDPOINT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type llm_selection_type: str

        """
        self.swagger_types = {
            'llm_selection_type': 'str'
        }
        self.attribute_map = {
            'llm_selection_type': 'llmSelectionType'
        }
        self._llm_selection_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['llmSelectionType']

        if type == 'DEFAULT':
            return 'DefaultLlmSelection'

        if type == 'CUSTOM_GEN_AI_ENDPOINT':
            return 'CustomGenAiEndpointLlmSelection'

        if type == 'CUSTOM_GEN_AI_MODEL':
            return 'CustomGenAiModelLlmSelection'
        else:
            return 'LlmSelection'

    @property
    def llm_selection_type(self):
        """
        **[Required]** Gets the llm_selection_type of this LlmSelection.
        Type of LLM selection

        Allowed values for this property are: "DEFAULT", "CUSTOM_GEN_AI_MODEL", "CUSTOM_GEN_AI_ENDPOINT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The llm_selection_type of this LlmSelection.
        :rtype: str
        """
        return self._llm_selection_type

    @llm_selection_type.setter
    def llm_selection_type(self, llm_selection_type):
        """
        Sets the llm_selection_type of this LlmSelection.
        Type of LLM selection


        :param llm_selection_type: The llm_selection_type of this LlmSelection.
        :type: str
        """
        allowed_values = ["DEFAULT", "CUSTOM_GEN_AI_MODEL", "CUSTOM_GEN_AI_ENDPOINT"]
        if not value_allowed_none_or_none_sentinel(llm_selection_type, allowed_values):
            llm_selection_type = 'UNKNOWN_ENUM_VALUE'
        self._llm_selection_type = llm_selection_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
