# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlatformRuntimeConfig(object):
    """
    Configuration for agent platform component.
    """

    #: A constant which can be used with the platform_runtime_config_type property of a PlatformRuntimeConfig.
    #: This constant has a value of "AGENT_PLATFORM"
    PLATFORM_RUNTIME_CONFIG_TYPE_AGENT_PLATFORM = "AGENT_PLATFORM"

    #: A constant which can be used with the platform_runtime_config_type property of a PlatformRuntimeConfig.
    #: This constant has a value of "FUSION_REASONING"
    PLATFORM_RUNTIME_CONFIG_TYPE_FUSION_REASONING = "FUSION_REASONING"

    def __init__(self, **kwargs):
        """
        Initializes a new PlatformRuntimeConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param platform_runtime_config_type:
            The value to assign to the platform_runtime_config_type property of this PlatformRuntimeConfig.
            Allowed values for this property are: "AGENT_PLATFORM", "FUSION_REASONING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type platform_runtime_config_type: str

        :param version:
            The value to assign to the version property of this PlatformRuntimeConfig.
        :type version: str

        """
        self.swagger_types = {
            'platform_runtime_config_type': 'str',
            'version': 'str'
        }
        self.attribute_map = {
            'platform_runtime_config_type': 'platformRuntimeConfigType',
            'version': 'version'
        }
        self._platform_runtime_config_type = None
        self._version = None

    @property
    def platform_runtime_config_type(self):
        """
        Gets the platform_runtime_config_type of this PlatformRuntimeConfig.
        The type of Platform runtime config.

        Allowed values for this property are: "AGENT_PLATFORM", "FUSION_REASONING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The platform_runtime_config_type of this PlatformRuntimeConfig.
        :rtype: str
        """
        return self._platform_runtime_config_type

    @platform_runtime_config_type.setter
    def platform_runtime_config_type(self, platform_runtime_config_type):
        """
        Sets the platform_runtime_config_type of this PlatformRuntimeConfig.
        The type of Platform runtime config.


        :param platform_runtime_config_type: The platform_runtime_config_type of this PlatformRuntimeConfig.
        :type: str
        """
        allowed_values = ["AGENT_PLATFORM", "FUSION_REASONING"]
        if not value_allowed_none_or_none_sentinel(platform_runtime_config_type, allowed_values):
            platform_runtime_config_type = 'UNKNOWN_ENUM_VALUE'
        self._platform_runtime_config_type = platform_runtime_config_type

    @property
    def version(self):
        """
        Gets the version of this PlatformRuntimeConfig.
        The version of the Core. The latest version will be displayed as default.


        :return: The version of this PlatformRuntimeConfig.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this PlatformRuntimeConfig.
        The version of the Core. The latest version will be displayed as default.


        :param version: The version of this PlatformRuntimeConfig.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
