# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_output import ToolOutput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RagToolOutput(ToolOutput):
    """
    Specifies the output format for RAG tool, including the generated answer and citations.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RagToolOutput object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.RagToolOutput.tool_output_type` attribute
        of this class is ``RAG_TOOL_OUTPUT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_id:
            The value to assign to the tool_id property of this RagToolOutput.
        :type tool_id: str

        :param tool_name:
            The value to assign to the tool_name property of this RagToolOutput.
        :type tool_name: str

        :param tool_output_type:
            The value to assign to the tool_output_type property of this RagToolOutput.
            Allowed values for this property are: "GENERIC_TOOL_OUTPUT", "SQL_TOOL_OUTPUT", "RAG_TOOL_OUTPUT"
        :type tool_output_type: str

        :param text:
            The value to assign to the text property of this RagToolOutput.
        :type text: str

        :param citations:
            The value to assign to the citations property of this RagToolOutput.
        :type citations: list[oci.generative_ai_agent_runtime.models.Citation]

        :param paragraph_citations:
            The value to assign to the paragraph_citations property of this RagToolOutput.
        :type paragraph_citations: list[oci.generative_ai_agent_runtime.models.ParagraphCitation]

        """
        self.swagger_types = {
            'tool_id': 'str',
            'tool_name': 'str',
            'tool_output_type': 'str',
            'text': 'str',
            'citations': 'list[Citation]',
            'paragraph_citations': 'list[ParagraphCitation]'
        }
        self.attribute_map = {
            'tool_id': 'toolId',
            'tool_name': 'toolName',
            'tool_output_type': 'toolOutputType',
            'text': 'text',
            'citations': 'citations',
            'paragraph_citations': 'paragraphCitations'
        }
        self._tool_id = None
        self._tool_name = None
        self._tool_output_type = None
        self._text = None
        self._citations = None
        self._paragraph_citations = None
        self._tool_output_type = 'RAG_TOOL_OUTPUT'

    @property
    def text(self):
        """
        **[Required]** Gets the text of this RagToolOutput.
        Specifies the generated answer from the RAG tool.


        :return: The text of this RagToolOutput.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this RagToolOutput.
        Specifies the generated answer from the RAG tool.


        :param text: The text of this RagToolOutput.
        :type: str
        """
        self._text = text

    @property
    def citations(self):
        """
        Gets the citations of this RagToolOutput.
        Citations to data sources used for tool's generated answer.


        :return: The citations of this RagToolOutput.
        :rtype: list[oci.generative_ai_agent_runtime.models.Citation]
        """
        return self._citations

    @citations.setter
    def citations(self, citations):
        """
        Sets the citations of this RagToolOutput.
        Citations to data sources used for tool's generated answer.


        :param citations: The citations of this RagToolOutput.
        :type: list[oci.generative_ai_agent_runtime.models.Citation]
        """
        self._citations = citations

    @property
    def paragraph_citations(self):
        """
        Gets the paragraph_citations of this RagToolOutput.
        A list of citations used to generate the paragraphs of the tool's generated answer.


        :return: The paragraph_citations of this RagToolOutput.
        :rtype: list[oci.generative_ai_agent_runtime.models.ParagraphCitation]
        """
        return self._paragraph_citations

    @paragraph_citations.setter
    def paragraph_citations(self, paragraph_citations):
        """
        Sets the paragraph_citations of this RagToolOutput.
        A list of citations used to generate the paragraphs of the tool's generated answer.


        :param paragraph_citations: The paragraph_citations of this RagToolOutput.
        :type: list[oci.generative_ai_agent_runtime.models.ParagraphCitation]
        """
        self._paragraph_citations = paragraph_citations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
