# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RetrieveMetadataDetails(object):
    """
    Details to retrieve metadata
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RetrieveMetadataDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param filters:
            The value to assign to the filters property of this RetrieveMetadataDetails.
        :type filters: list[oci.generative_ai_agent_runtime.models.MetadataFilter]

        """
        self.swagger_types = {
            'filters': 'list[MetadataFilter]'
        }
        self.attribute_map = {
            'filters': 'filters'
        }
        self._filters = None

    @property
    def filters(self):
        """
        Gets the filters of this RetrieveMetadataDetails.
        List of metadata filters to narrow down the retrieved metadata


        :return: The filters of this RetrieveMetadataDetails.
        :rtype: list[oci.generative_ai_agent_runtime.models.MetadataFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this RetrieveMetadataDetails.
        List of metadata filters to narrow down the retrieved metadata


        :param filters: The filters of this RetrieveMetadataDetails.
        :type: list[oci.generative_ai_agent_runtime.models.MetadataFilter]
        """
        self._filters = filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
