# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .message import Message
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssistantMessage(Message):
    """
    Represents a single instance of assistant message.

    Note: When responding to a tool call, set `content` to `null` (not `\"\"`).
    This ensures the model correctly processes tool call messages in multi-step interactions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssistantMessage object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.AssistantMessage.role` attribute
        of this class is ``ASSISTANT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role:
            The value to assign to the role property of this AssistantMessage.
            Allowed values for this property are: "SYSTEM", "ASSISTANT", "USER", "TOOL", "DEVELOPER"
        :type role: str

        :param content:
            The value to assign to the content property of this AssistantMessage.
        :type content: list[oci.generative_ai_inference.models.ChatContent]

        :param name:
            The value to assign to the name property of this AssistantMessage.
        :type name: str

        :param refusal:
            The value to assign to the refusal property of this AssistantMessage.
        :type refusal: str

        :param tool_calls:
            The value to assign to the tool_calls property of this AssistantMessage.
        :type tool_calls: list[oci.generative_ai_inference.models.ToolCall]

        :param annotations:
            The value to assign to the annotations property of this AssistantMessage.
        :type annotations: list[oci.generative_ai_inference.models.Annotation]

        :param reasoning_content:
            The value to assign to the reasoning_content property of this AssistantMessage.
        :type reasoning_content: str

        """
        self.swagger_types = {
            'role': 'str',
            'content': 'list[ChatContent]',
            'name': 'str',
            'refusal': 'str',
            'tool_calls': 'list[ToolCall]',
            'annotations': 'list[Annotation]',
            'reasoning_content': 'str'
        }
        self.attribute_map = {
            'role': 'role',
            'content': 'content',
            'name': 'name',
            'refusal': 'refusal',
            'tool_calls': 'toolCalls',
            'annotations': 'annotations',
            'reasoning_content': 'reasoningContent'
        }
        self._role = None
        self._content = None
        self._name = None
        self._refusal = None
        self._tool_calls = None
        self._annotations = None
        self._reasoning_content = None
        self._role = 'ASSISTANT'

    @property
    def name(self):
        """
        Gets the name of this AssistantMessage.
        An optional name for the participant. Provides the model information to differentiate between participants of the same role.


        :return: The name of this AssistantMessage.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssistantMessage.
        An optional name for the participant. Provides the model information to differentiate between participants of the same role.


        :param name: The name of this AssistantMessage.
        :type: str
        """
        self._name = name

    @property
    def refusal(self):
        """
        Gets the refusal of this AssistantMessage.
        The refusal message by the assistant.


        :return: The refusal of this AssistantMessage.
        :rtype: str
        """
        return self._refusal

    @refusal.setter
    def refusal(self, refusal):
        """
        Sets the refusal of this AssistantMessage.
        The refusal message by the assistant.


        :param refusal: The refusal of this AssistantMessage.
        :type: str
        """
        self._refusal = refusal

    @property
    def tool_calls(self):
        """
        Gets the tool_calls of this AssistantMessage.
        The tool calls generated by the model, such as function calls.


        :return: The tool_calls of this AssistantMessage.
        :rtype: list[oci.generative_ai_inference.models.ToolCall]
        """
        return self._tool_calls

    @tool_calls.setter
    def tool_calls(self, tool_calls):
        """
        Sets the tool_calls of this AssistantMessage.
        The tool calls generated by the model, such as function calls.


        :param tool_calls: The tool_calls of this AssistantMessage.
        :type: list[oci.generative_ai_inference.models.ToolCall]
        """
        self._tool_calls = tool_calls

    @property
    def annotations(self):
        """
        Gets the annotations of this AssistantMessage.
        List of annotations generated by the model, including inline citations from web search results.


        :return: The annotations of this AssistantMessage.
        :rtype: list[oci.generative_ai_inference.models.Annotation]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """
        Sets the annotations of this AssistantMessage.
        List of annotations generated by the model, including inline citations from web search results.


        :param annotations: The annotations of this AssistantMessage.
        :type: list[oci.generative_ai_inference.models.Annotation]
        """
        self._annotations = annotations

    @property
    def reasoning_content(self):
        """
        Gets the reasoning_content of this AssistantMessage.
        Internal reasoning trace generated during response computation.


        :return: The reasoning_content of this AssistantMessage.
        :rtype: str
        """
        return self._reasoning_content

    @reasoning_content.setter
    def reasoning_content(self, reasoning_content):
        """
        Sets the reasoning_content of this AssistantMessage.
        Internal reasoning trace generated during response computation.


        :param reasoning_content: The reasoning_content of this AssistantMessage.
        :type: str
        """
        self._reasoning_content = reasoning_content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
