# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .base_chat_request import BaseChatRequest
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereChatRequestV2(BaseChatRequest):
    """
    Details for the chat request for Cohere models.
    """

    #: A constant which can be used with the tools_choice property of a CohereChatRequestV2.
    #: This constant has a value of "REQUIRED"
    TOOLS_CHOICE_REQUIRED = "REQUIRED"

    #: A constant which can be used with the tools_choice property of a CohereChatRequestV2.
    #: This constant has a value of "NONE"
    TOOLS_CHOICE_NONE = "NONE"

    #: A constant which can be used with the safety_mode property of a CohereChatRequestV2.
    #: This constant has a value of "CONTEXTUAL"
    SAFETY_MODE_CONTEXTUAL = "CONTEXTUAL"

    #: A constant which can be used with the safety_mode property of a CohereChatRequestV2.
    #: This constant has a value of "STRICT"
    SAFETY_MODE_STRICT = "STRICT"

    #: A constant which can be used with the safety_mode property of a CohereChatRequestV2.
    #: This constant has a value of "OFF"
    SAFETY_MODE_OFF = "OFF"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereChatRequestV2 object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereChatRequestV2.api_format` attribute
        of this class is ``COHEREV2`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_format:
            The value to assign to the api_format property of this CohereChatRequestV2.
            Allowed values for this property are: "COHERE", "COHEREV2", "GENERIC"
        :type api_format: str

        :param messages:
            The value to assign to the messages property of this CohereChatRequestV2.
        :type messages: list[oci.generative_ai_inference.models.CohereMessageV2]

        :param documents:
            The value to assign to the documents property of this CohereChatRequestV2.
        :type documents: list[object]

        :param citation_options:
            The value to assign to the citation_options property of this CohereChatRequestV2.
        :type citation_options: oci.generative_ai_inference.models.CitationOptionsV2

        :param tools_choice:
            The value to assign to the tools_choice property of this CohereChatRequestV2.
            Allowed values for this property are: "REQUIRED", "NONE"
        :type tools_choice: str

        :param tools:
            The value to assign to the tools property of this CohereChatRequestV2.
        :type tools: list[oci.generative_ai_inference.models.CohereToolV2]

        :param is_strict_tools_enabled:
            The value to assign to the is_strict_tools_enabled property of this CohereChatRequestV2.
        :type is_strict_tools_enabled: bool

        :param is_log_probs_enabled:
            The value to assign to the is_log_probs_enabled property of this CohereChatRequestV2.
        :type is_log_probs_enabled: bool

        :param thinking:
            The value to assign to the thinking property of this CohereChatRequestV2.
        :type thinking: oci.generative_ai_inference.models.CohereThinkingV2

        :param response_format:
            The value to assign to the response_format property of this CohereChatRequestV2.
        :type response_format: oci.generative_ai_inference.models.CohereResponseFormat

        :param is_search_queries_only:
            The value to assign to the is_search_queries_only property of this CohereChatRequestV2.
        :type is_search_queries_only: bool

        :param stream_options:
            The value to assign to the stream_options property of this CohereChatRequestV2.
        :type stream_options: oci.generative_ai_inference.models.StreamOptions

        :param is_stream:
            The value to assign to the is_stream property of this CohereChatRequestV2.
        :type is_stream: bool

        :param max_tokens:
            The value to assign to the max_tokens property of this CohereChatRequestV2.
        :type max_tokens: int

        :param temperature:
            The value to assign to the temperature property of this CohereChatRequestV2.
        :type temperature: float

        :param top_k:
            The value to assign to the top_k property of this CohereChatRequestV2.
        :type top_k: int

        :param top_p:
            The value to assign to the top_p property of this CohereChatRequestV2.
        :type top_p: float

        :param frequency_penalty:
            The value to assign to the frequency_penalty property of this CohereChatRequestV2.
        :type frequency_penalty: float

        :param presence_penalty:
            The value to assign to the presence_penalty property of this CohereChatRequestV2.
        :type presence_penalty: float

        :param seed:
            The value to assign to the seed property of this CohereChatRequestV2.
        :type seed: int

        :param stop_sequences:
            The value to assign to the stop_sequences property of this CohereChatRequestV2.
        :type stop_sequences: list[str]

        :param priority:
            The value to assign to the priority property of this CohereChatRequestV2.
        :type priority: int

        :param is_raw_prompting:
            The value to assign to the is_raw_prompting property of this CohereChatRequestV2.
        :type is_raw_prompting: bool

        :param safety_mode:
            The value to assign to the safety_mode property of this CohereChatRequestV2.
            Allowed values for this property are: "CONTEXTUAL", "STRICT", "OFF"
        :type safety_mode: str

        """
        self.swagger_types = {
            'api_format': 'str',
            'messages': 'list[CohereMessageV2]',
            'documents': 'list[object]',
            'citation_options': 'CitationOptionsV2',
            'tools_choice': 'str',
            'tools': 'list[CohereToolV2]',
            'is_strict_tools_enabled': 'bool',
            'is_log_probs_enabled': 'bool',
            'thinking': 'CohereThinkingV2',
            'response_format': 'CohereResponseFormat',
            'is_search_queries_only': 'bool',
            'stream_options': 'StreamOptions',
            'is_stream': 'bool',
            'max_tokens': 'int',
            'temperature': 'float',
            'top_k': 'int',
            'top_p': 'float',
            'frequency_penalty': 'float',
            'presence_penalty': 'float',
            'seed': 'int',
            'stop_sequences': 'list[str]',
            'priority': 'int',
            'is_raw_prompting': 'bool',
            'safety_mode': 'str'
        }
        self.attribute_map = {
            'api_format': 'apiFormat',
            'messages': 'messages',
            'documents': 'documents',
            'citation_options': 'citationOptions',
            'tools_choice': 'toolsChoice',
            'tools': 'tools',
            'is_strict_tools_enabled': 'isStrictToolsEnabled',
            'is_log_probs_enabled': 'isLogProbsEnabled',
            'thinking': 'thinking',
            'response_format': 'responseFormat',
            'is_search_queries_only': 'isSearchQueriesOnly',
            'stream_options': 'streamOptions',
            'is_stream': 'isStream',
            'max_tokens': 'maxTokens',
            'temperature': 'temperature',
            'top_k': 'topK',
            'top_p': 'topP',
            'frequency_penalty': 'frequencyPenalty',
            'presence_penalty': 'presencePenalty',
            'seed': 'seed',
            'stop_sequences': 'stopSequences',
            'priority': 'priority',
            'is_raw_prompting': 'isRawPrompting',
            'safety_mode': 'safetyMode'
        }
        self._api_format = None
        self._messages = None
        self._documents = None
        self._citation_options = None
        self._tools_choice = None
        self._tools = None
        self._is_strict_tools_enabled = None
        self._is_log_probs_enabled = None
        self._thinking = None
        self._response_format = None
        self._is_search_queries_only = None
        self._stream_options = None
        self._is_stream = None
        self._max_tokens = None
        self._temperature = None
        self._top_k = None
        self._top_p = None
        self._frequency_penalty = None
        self._presence_penalty = None
        self._seed = None
        self._stop_sequences = None
        self._priority = None
        self._is_raw_prompting = None
        self._safety_mode = None
        self._api_format = 'COHEREV2'

    @property
    def messages(self):
        """
        **[Required]** Gets the messages of this CohereChatRequestV2.
        A list of chat messages in chronological order, representing a conversation between the user and the model.


        :return: The messages of this CohereChatRequestV2.
        :rtype: list[oci.generative_ai_inference.models.CohereMessageV2]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """
        Sets the messages of this CohereChatRequestV2.
        A list of chat messages in chronological order, representing a conversation between the user and the model.


        :param messages: The messages of this CohereChatRequestV2.
        :type: list[oci.generative_ai_inference.models.CohereMessageV2]
        """
        self._messages = messages

    @property
    def documents(self):
        """
        Gets the documents of this CohereChatRequestV2.
        A list of relevant documents that the model can refer to for generating grounded responses to the user's requests.
        Some example keys that you can add to the dictionary are \"text\", \"author\", and \"date\". Keep the total word count of the strings in the dictionary to 300 words or less.


        :return: The documents of this CohereChatRequestV2.
        :rtype: list[object]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this CohereChatRequestV2.
        A list of relevant documents that the model can refer to for generating grounded responses to the user's requests.
        Some example keys that you can add to the dictionary are \"text\", \"author\", and \"date\". Keep the total word count of the strings in the dictionary to 300 words or less.


        :param documents: The documents of this CohereChatRequestV2.
        :type: list[object]
        """
        self._documents = documents

    @property
    def citation_options(self):
        """
        Gets the citation_options of this CohereChatRequestV2.

        :return: The citation_options of this CohereChatRequestV2.
        :rtype: oci.generative_ai_inference.models.CitationOptionsV2
        """
        return self._citation_options

    @citation_options.setter
    def citation_options(self, citation_options):
        """
        Sets the citation_options of this CohereChatRequestV2.

        :param citation_options: The citation_options of this CohereChatRequestV2.
        :type: oci.generative_ai_inference.models.CitationOptionsV2
        """
        self._citation_options = citation_options

    @property
    def tools_choice(self):
        """
        Gets the tools_choice of this CohereChatRequestV2.
        Used to control whether or not the model will be forced to use a tool when answering. When REQUIRED is specified, the model will be forced to use at least one of the user-defined tools, and the tools parameter must be passed in the request. When NONE is specified, the model will be forced not to use one of the specified tools, and give a direct response. If tool_choice isn\u2019t specified, then the model is free to choose whether to use the specified tools or not. Note:This parameter is only compatible with models Command-r7b and newer.

        Allowed values for this property are: "REQUIRED", "NONE"


        :return: The tools_choice of this CohereChatRequestV2.
        :rtype: str
        """
        return self._tools_choice

    @tools_choice.setter
    def tools_choice(self, tools_choice):
        """
        Sets the tools_choice of this CohereChatRequestV2.
        Used to control whether or not the model will be forced to use a tool when answering. When REQUIRED is specified, the model will be forced to use at least one of the user-defined tools, and the tools parameter must be passed in the request. When NONE is specified, the model will be forced not to use one of the specified tools, and give a direct response. If tool_choice isn\u2019t specified, then the model is free to choose whether to use the specified tools or not. Note:This parameter is only compatible with models Command-r7b and newer.


        :param tools_choice: The tools_choice of this CohereChatRequestV2.
        :type: str
        """
        allowed_values = ["REQUIRED", "NONE"]
        if not value_allowed_none_or_none_sentinel(tools_choice, allowed_values):
            raise ValueError(
                f"Invalid value for `tools_choice`, must be None or one of {allowed_values}"
            )
        self._tools_choice = tools_choice

    @property
    def tools(self):
        """
        Gets the tools of this CohereChatRequestV2.
        A list of available tools (functions) that the model may suggest invoking before producing a text response.


        :return: The tools of this CohereChatRequestV2.
        :rtype: list[oci.generative_ai_inference.models.CohereToolV2]
        """
        return self._tools

    @tools.setter
    def tools(self, tools):
        """
        Sets the tools of this CohereChatRequestV2.
        A list of available tools (functions) that the model may suggest invoking before producing a text response.


        :param tools: The tools of this CohereChatRequestV2.
        :type: list[oci.generative_ai_inference.models.CohereToolV2]
        """
        self._tools = tools

    @property
    def is_strict_tools_enabled(self):
        """
        Gets the is_strict_tools_enabled of this CohereChatRequestV2.
        When set to true, tool calls in the Assistant message will be forced to follow the tool definition strictly. Note:The first few requests with a new set of tools will take longer to process.


        :return: The is_strict_tools_enabled of this CohereChatRequestV2.
        :rtype: bool
        """
        return self._is_strict_tools_enabled

    @is_strict_tools_enabled.setter
    def is_strict_tools_enabled(self, is_strict_tools_enabled):
        """
        Sets the is_strict_tools_enabled of this CohereChatRequestV2.
        When set to true, tool calls in the Assistant message will be forced to follow the tool definition strictly. Note:The first few requests with a new set of tools will take longer to process.


        :param is_strict_tools_enabled: The is_strict_tools_enabled of this CohereChatRequestV2.
        :type: bool
        """
        self._is_strict_tools_enabled = is_strict_tools_enabled

    @property
    def is_log_probs_enabled(self):
        """
        Gets the is_log_probs_enabled of this CohereChatRequestV2.
        The log probabilities of the generated tokens will be included in the response.


        :return: The is_log_probs_enabled of this CohereChatRequestV2.
        :rtype: bool
        """
        return self._is_log_probs_enabled

    @is_log_probs_enabled.setter
    def is_log_probs_enabled(self, is_log_probs_enabled):
        """
        Sets the is_log_probs_enabled of this CohereChatRequestV2.
        The log probabilities of the generated tokens will be included in the response.


        :param is_log_probs_enabled: The is_log_probs_enabled of this CohereChatRequestV2.
        :type: bool
        """
        self._is_log_probs_enabled = is_log_probs_enabled

    @property
    def thinking(self):
        """
        Gets the thinking of this CohereChatRequestV2.

        :return: The thinking of this CohereChatRequestV2.
        :rtype: oci.generative_ai_inference.models.CohereThinkingV2
        """
        return self._thinking

    @thinking.setter
    def thinking(self, thinking):
        """
        Sets the thinking of this CohereChatRequestV2.

        :param thinking: The thinking of this CohereChatRequestV2.
        :type: oci.generative_ai_inference.models.CohereThinkingV2
        """
        self._thinking = thinking

    @property
    def response_format(self):
        """
        Gets the response_format of this CohereChatRequestV2.

        :return: The response_format of this CohereChatRequestV2.
        :rtype: oci.generative_ai_inference.models.CohereResponseFormat
        """
        return self._response_format

    @response_format.setter
    def response_format(self, response_format):
        """
        Sets the response_format of this CohereChatRequestV2.

        :param response_format: The response_format of this CohereChatRequestV2.
        :type: oci.generative_ai_inference.models.CohereResponseFormat
        """
        self._response_format = response_format

    @property
    def is_search_queries_only(self):
        """
        Gets the is_search_queries_only of this CohereChatRequestV2.
        When set to true, the response contains only a list of generated search queries without the search results and the model will not respond to the user's message.


        :return: The is_search_queries_only of this CohereChatRequestV2.
        :rtype: bool
        """
        return self._is_search_queries_only

    @is_search_queries_only.setter
    def is_search_queries_only(self, is_search_queries_only):
        """
        Sets the is_search_queries_only of this CohereChatRequestV2.
        When set to true, the response contains only a list of generated search queries without the search results and the model will not respond to the user's message.


        :param is_search_queries_only: The is_search_queries_only of this CohereChatRequestV2.
        :type: bool
        """
        self._is_search_queries_only = is_search_queries_only

    @property
    def stream_options(self):
        """
        Gets the stream_options of this CohereChatRequestV2.

        :return: The stream_options of this CohereChatRequestV2.
        :rtype: oci.generative_ai_inference.models.StreamOptions
        """
        return self._stream_options

    @stream_options.setter
    def stream_options(self, stream_options):
        """
        Sets the stream_options of this CohereChatRequestV2.

        :param stream_options: The stream_options of this CohereChatRequestV2.
        :type: oci.generative_ai_inference.models.StreamOptions
        """
        self._stream_options = stream_options

    @property
    def is_stream(self):
        """
        Gets the is_stream of this CohereChatRequestV2.
        Whether to stream the partial progress of the model's response. When set to true, as tokens become available, they are sent as data-only server-sent events.


        :return: The is_stream of this CohereChatRequestV2.
        :rtype: bool
        """
        return self._is_stream

    @is_stream.setter
    def is_stream(self, is_stream):
        """
        Sets the is_stream of this CohereChatRequestV2.
        Whether to stream the partial progress of the model's response. When set to true, as tokens become available, they are sent as data-only server-sent events.


        :param is_stream: The is_stream of this CohereChatRequestV2.
        :type: bool
        """
        self._is_stream = is_stream

    @property
    def max_tokens(self):
        """
        Gets the max_tokens of this CohereChatRequestV2.
        The maximum number of output tokens that the model will generate for the response. The token count of your prompt plus maxTokens must not exceed the model's context length. For on-demand inferencing, the response length is capped at 4,000 tokens for each run.


        :return: The max_tokens of this CohereChatRequestV2.
        :rtype: int
        """
        return self._max_tokens

    @max_tokens.setter
    def max_tokens(self, max_tokens):
        """
        Sets the max_tokens of this CohereChatRequestV2.
        The maximum number of output tokens that the model will generate for the response. The token count of your prompt plus maxTokens must not exceed the model's context length. For on-demand inferencing, the response length is capped at 4,000 tokens for each run.


        :param max_tokens: The max_tokens of this CohereChatRequestV2.
        :type: int
        """
        self._max_tokens = max_tokens

    @property
    def temperature(self):
        """
        Gets the temperature of this CohereChatRequestV2.
        A number that sets the randomness of the generated output. A lower temperature means less random generations.
        Use lower numbers for tasks such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :return: The temperature of this CohereChatRequestV2.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this CohereChatRequestV2.
        A number that sets the randomness of the generated output. A lower temperature means less random generations.
        Use lower numbers for tasks such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :param temperature: The temperature of this CohereChatRequestV2.
        :type: float
        """
        self._temperature = temperature

    @property
    def top_k(self):
        """
        Gets the top_k of this CohereChatRequestV2.
        A sampling method in which the model chooses the next token randomly from the top k most likely tokens. A higher value for k generates more random output, which makes the output text sound more natural. The default value for k is 0 which disables this method and considers all tokens. To set a number for the likely tokens, choose an integer between 1 and 500.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20 but only the probabilities of the top 10 add up to the value of p, then only the top 10 tokens are chosen.


        :return: The top_k of this CohereChatRequestV2.
        :rtype: int
        """
        return self._top_k

    @top_k.setter
    def top_k(self, top_k):
        """
        Sets the top_k of this CohereChatRequestV2.
        A sampling method in which the model chooses the next token randomly from the top k most likely tokens. A higher value for k generates more random output, which makes the output text sound more natural. The default value for k is 0 which disables this method and considers all tokens. To set a number for the likely tokens, choose an integer between 1 and 500.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20 but only the probabilities of the top 10 add up to the value of p, then only the top 10 tokens are chosen.


        :param top_k: The top_k of this CohereChatRequestV2.
        :type: int
        """
        self._top_k = top_k

    @property
    def top_p(self):
        """
        Gets the top_p of this CohereChatRequestV2.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1.0 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :return: The top_p of this CohereChatRequestV2.
        :rtype: float
        """
        return self._top_p

    @top_p.setter
    def top_p(self, top_p):
        """
        Sets the top_p of this CohereChatRequestV2.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1.0 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :param top_p: The top_p of this CohereChatRequestV2.
        :type: float
        """
        self._top_p = top_p

    @property
    def frequency_penalty(self):
        """
        Gets the frequency_penalty of this CohereChatRequestV2.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens. Set to 0 to disable.


        :return: The frequency_penalty of this CohereChatRequestV2.
        :rtype: float
        """
        return self._frequency_penalty

    @frequency_penalty.setter
    def frequency_penalty(self, frequency_penalty):
        """
        Sets the frequency_penalty of this CohereChatRequestV2.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens. Set to 0 to disable.


        :param frequency_penalty: The frequency_penalty of this CohereChatRequestV2.
        :type: float
        """
        self._frequency_penalty = frequency_penalty

    @property
    def presence_penalty(self):
        """
        Gets the presence_penalty of this CohereChatRequestV2.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :return: The presence_penalty of this CohereChatRequestV2.
        :rtype: float
        """
        return self._presence_penalty

    @presence_penalty.setter
    def presence_penalty(self, presence_penalty):
        """
        Sets the presence_penalty of this CohereChatRequestV2.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :param presence_penalty: The presence_penalty of this CohereChatRequestV2.
        :type: float
        """
        self._presence_penalty = presence_penalty

    @property
    def seed(self):
        """
        Gets the seed of this CohereChatRequestV2.
        If specified, the backend will make a best effort to sample tokens deterministically, so that repeated requests with the same seed and parameters yield the same result. However, determinism cannot be fully guaranteed.


        :return: The seed of this CohereChatRequestV2.
        :rtype: int
        """
        return self._seed

    @seed.setter
    def seed(self, seed):
        """
        Sets the seed of this CohereChatRequestV2.
        If specified, the backend will make a best effort to sample tokens deterministically, so that repeated requests with the same seed and parameters yield the same result. However, determinism cannot be fully guaranteed.


        :param seed: The seed of this CohereChatRequestV2.
        :type: int
        """
        self._seed = seed

    @property
    def stop_sequences(self):
        """
        Gets the stop_sequences of this CohereChatRequestV2.
        Stop the model generation when it reaches a stop sequence defined in this parameter.


        :return: The stop_sequences of this CohereChatRequestV2.
        :rtype: list[str]
        """
        return self._stop_sequences

    @stop_sequences.setter
    def stop_sequences(self, stop_sequences):
        """
        Sets the stop_sequences of this CohereChatRequestV2.
        Stop the model generation when it reaches a stop sequence defined in this parameter.


        :param stop_sequences: The stop_sequences of this CohereChatRequestV2.
        :type: list[str]
        """
        self._stop_sequences = stop_sequences

    @property
    def priority(self):
        """
        Gets the priority of this CohereChatRequestV2.
        The priority of the request (lower means earlier handling; default 0 highest priority). Higher priority requests are handled first, and dropped last when the system is under load.


        :return: The priority of this CohereChatRequestV2.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this CohereChatRequestV2.
        The priority of the request (lower means earlier handling; default 0 highest priority). Higher priority requests are handled first, and dropped last when the system is under load.


        :param priority: The priority of this CohereChatRequestV2.
        :type: int
        """
        self._priority = priority

    @property
    def is_raw_prompting(self):
        """
        Gets the is_raw_prompting of this CohereChatRequestV2.
        When enabled, the user\u2019s `message` will be sent to the model without any preprocessing.


        :return: The is_raw_prompting of this CohereChatRequestV2.
        :rtype: bool
        """
        return self._is_raw_prompting

    @is_raw_prompting.setter
    def is_raw_prompting(self, is_raw_prompting):
        """
        Sets the is_raw_prompting of this CohereChatRequestV2.
        When enabled, the user\u2019s `message` will be sent to the model without any preprocessing.


        :param is_raw_prompting: The is_raw_prompting of this CohereChatRequestV2.
        :type: bool
        """
        self._is_raw_prompting = is_raw_prompting

    @property
    def safety_mode(self):
        """
        Gets the safety_mode of this CohereChatRequestV2.
        Safety mode: Adds a safety instruction for the model to use when generating responses.
        Contextual: (Default) Puts fewer constraints on the output. It maintains core protections by aiming to reject harmful or illegal suggestions, but it allows profanity and some toxic content, sexually explicit and violent content, and content that contains medical, financial, or legal information. Contextual mode is suited for entertainment, creative, or academic use.
        Strict: Aims to avoid sensitive topics, such as violent or sexual acts and profanity. This mode aims to provide a safer experience by prohibiting responses or recommendations that it finds inappropriate. Strict mode is suited for corporate use, such as for corporate communications and customer service.
        Off: No safety mode is applied.
        Note: This parameter is only compatible with models cohere.command-r-08-2024, cohere.command-r-plus-08-2024 and Cohere models released after these models. See `release dates`__.

        __ https://docs.cloud.oracle.com/iaas/Content/generative-ai/deprecating.htm

        Allowed values for this property are: "CONTEXTUAL", "STRICT", "OFF"


        :return: The safety_mode of this CohereChatRequestV2.
        :rtype: str
        """
        return self._safety_mode

    @safety_mode.setter
    def safety_mode(self, safety_mode):
        """
        Sets the safety_mode of this CohereChatRequestV2.
        Safety mode: Adds a safety instruction for the model to use when generating responses.
        Contextual: (Default) Puts fewer constraints on the output. It maintains core protections by aiming to reject harmful or illegal suggestions, but it allows profanity and some toxic content, sexually explicit and violent content, and content that contains medical, financial, or legal information. Contextual mode is suited for entertainment, creative, or academic use.
        Strict: Aims to avoid sensitive topics, such as violent or sexual acts and profanity. This mode aims to provide a safer experience by prohibiting responses or recommendations that it finds inappropriate. Strict mode is suited for corporate use, such as for corporate communications and customer service.
        Off: No safety mode is applied.
        Note: This parameter is only compatible with models cohere.command-r-08-2024, cohere.command-r-plus-08-2024 and Cohere models released after these models. See `release dates`__.

        __ https://docs.cloud.oracle.com/iaas/Content/generative-ai/deprecating.htm


        :param safety_mode: The safety_mode of this CohereChatRequestV2.
        :type: str
        """
        allowed_values = ["CONTEXTUAL", "STRICT", "OFF"]
        if not value_allowed_none_or_none_sentinel(safety_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `safety_mode`, must be None or one of {allowed_values}"
            )
        self._safety_mode = safety_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
