# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .llm_inference_response import LlmInferenceResponse
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereLlmInferenceResponse(LlmInferenceResponse):
    """
    The generated text result to return.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereLlmInferenceResponse object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereLlmInferenceResponse.runtime_type` attribute
        of this class is ``COHERE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param runtime_type:
            The value to assign to the runtime_type property of this CohereLlmInferenceResponse.
            Allowed values for this property are: "COHERE", "LLAMA"
        :type runtime_type: str

        :param generated_texts:
            The value to assign to the generated_texts property of this CohereLlmInferenceResponse.
        :type generated_texts: list[oci.generative_ai_inference.models.GeneratedText]

        :param time_created:
            The value to assign to the time_created property of this CohereLlmInferenceResponse.
        :type time_created: datetime

        :param prompt:
            The value to assign to the prompt property of this CohereLlmInferenceResponse.
        :type prompt: str

        """
        self.swagger_types = {
            'runtime_type': 'str',
            'generated_texts': 'list[GeneratedText]',
            'time_created': 'datetime',
            'prompt': 'str'
        }
        self.attribute_map = {
            'runtime_type': 'runtimeType',
            'generated_texts': 'generatedTexts',
            'time_created': 'timeCreated',
            'prompt': 'prompt'
        }
        self._runtime_type = None
        self._generated_texts = None
        self._time_created = None
        self._prompt = None
        self._runtime_type = 'COHERE'

    @property
    def generated_texts(self):
        """
        **[Required]** Gets the generated_texts of this CohereLlmInferenceResponse.
        Each prompt in the input array has an array of GeneratedText, controlled by numGenerations parameter in the request.


        :return: The generated_texts of this CohereLlmInferenceResponse.
        :rtype: list[oci.generative_ai_inference.models.GeneratedText]
        """
        return self._generated_texts

    @generated_texts.setter
    def generated_texts(self, generated_texts):
        """
        Sets the generated_texts of this CohereLlmInferenceResponse.
        Each prompt in the input array has an array of GeneratedText, controlled by numGenerations parameter in the request.


        :param generated_texts: The generated_texts of this CohereLlmInferenceResponse.
        :type: list[oci.generative_ai_inference.models.GeneratedText]
        """
        self._generated_texts = generated_texts

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CohereLlmInferenceResponse.
        The date and time that the model was created in an RFC3339 formatted datetime string.


        :return: The time_created of this CohereLlmInferenceResponse.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CohereLlmInferenceResponse.
        The date and time that the model was created in an RFC3339 formatted datetime string.


        :param time_created: The time_created of this CohereLlmInferenceResponse.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def prompt(self):
        """
        Gets the prompt of this CohereLlmInferenceResponse.
        Represents the original prompt. Applies only to non-stream responses.


        :return: The prompt of this CohereLlmInferenceResponse.
        :rtype: str
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt):
        """
        Sets the prompt of this CohereLlmInferenceResponse.
        Represents the original prompt. Applies only to non-stream responses.


        :param prompt: The prompt of this CohereLlmInferenceResponse.
        :type: str
        """
        self._prompt = prompt

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
