# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereToolV2(object):
    """
    A definition of tool (function).
    """

    #: A constant which can be used with the type property of a CohereToolV2.
    #: This constant has a value of "FUNCTION"
    TYPE_FUNCTION = "FUNCTION"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereToolV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CohereToolV2.
            Allowed values for this property are: "FUNCTION"
        :type type: str

        :param function:
            The value to assign to the function property of this CohereToolV2.
        :type function: oci.generative_ai_inference.models.Function

        """
        self.swagger_types = {
            'type': 'str',
            'function': 'Function'
        }
        self.attribute_map = {
            'type': 'type',
            'function': 'function'
        }
        self._type = None
        self._function = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CohereToolV2.
        The name of the tool to be called. Valid names contain only the characters a-z, A-Z, 0-9, _ and must not begin with a digit.

        Allowed values for this property are: "FUNCTION"


        :return: The type of this CohereToolV2.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CohereToolV2.
        The name of the tool to be called. Valid names contain only the characters a-z, A-Z, 0-9, _ and must not begin with a digit.


        :param type: The type of this CohereToolV2.
        :type: str
        """
        allowed_values = ["FUNCTION"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def function(self):
        """
        **[Required]** Gets the function of this CohereToolV2.

        :return: The function of this CohereToolV2.
        :rtype: oci.generative_ai_inference.models.Function
        """
        return self._function

    @function.setter
    def function(self, function):
        """
        Sets the function of this CohereToolV2.

        :param function: The function of this CohereToolV2.
        :type: oci.generative_ai_inference.models.Function
        """
        self._function = function

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
