# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Function(object):
    """
    The function to be executed.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Function object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Function.
        :type name: str

        :param description:
            The value to assign to the description property of this Function.
        :type description: str

        :param parameters:
            The value to assign to the parameters property of this Function.
        :type parameters: object

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'parameters': 'object'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'parameters': 'parameters'
        }
        self._name = None
        self._description = None
        self._parameters = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this Function.
        The name of the function.


        :return: The name of this Function.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Function.
        The name of the function.


        :param name: The name of this Function.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Function.
        The description of the function.


        :return: The description of this Function.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Function.
        The description of the function.


        :param description: The description of this Function.
        :type: str
        """
        self._description = description

    @property
    def parameters(self):
        """
        **[Required]** Gets the parameters of this Function.
        The parameters of the function as JSON schema.


        :return: The parameters of this Function.
        :rtype: object
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this Function.
        The parameters of the function as JSON schema.


        :param parameters: The parameters of this Function.
        :type: object
        """
        self._parameters = parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
