# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .iceberg_storage import IcebergStorage
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AzureDataLakeStorageIcebergStorage(IcebergStorage):
    """
    Represents an Azure Data Lake Storage storage used in the Iceberg connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AzureDataLakeStorageIcebergStorage object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.AzureDataLakeStorageIcebergStorage.storage_type` attribute
        of this class is ``AZURE_DATA_LAKE_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this AzureDataLakeStorageIcebergStorage.
            Allowed values for this property are: "AMAZON_S3", "GOOGLE_CLOUD_STORAGE", "AZURE_DATA_LAKE_STORAGE"
        :type storage_type: str

        :param account_name:
            The value to assign to the account_name property of this AzureDataLakeStorageIcebergStorage.
        :type account_name: str

        :param container:
            The value to assign to the container property of this AzureDataLakeStorageIcebergStorage.
        :type container: str

        :param account_key_secret_id:
            The value to assign to the account_key_secret_id property of this AzureDataLakeStorageIcebergStorage.
        :type account_key_secret_id: str

        :param endpoint:
            The value to assign to the endpoint property of this AzureDataLakeStorageIcebergStorage.
        :type endpoint: str

        """
        self.swagger_types = {
            'storage_type': 'str',
            'account_name': 'str',
            'container': 'str',
            'account_key_secret_id': 'str',
            'endpoint': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType',
            'account_name': 'accountName',
            'container': 'container',
            'account_key_secret_id': 'accountKeySecretId',
            'endpoint': 'endpoint'
        }
        self._storage_type = None
        self._account_name = None
        self._container = None
        self._account_key_secret_id = None
        self._endpoint = None
        self._storage_type = 'AZURE_DATA_LAKE_STORAGE'

    @property
    def account_name(self):
        """
        **[Required]** Gets the account_name of this AzureDataLakeStorageIcebergStorage.
        Sets the Azure storage account name.


        :return: The account_name of this AzureDataLakeStorageIcebergStorage.
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """
        Sets the account_name of this AzureDataLakeStorageIcebergStorage.
        Sets the Azure storage account name.


        :param account_name: The account_name of this AzureDataLakeStorageIcebergStorage.
        :type: str
        """
        self._account_name = account_name

    @property
    def container(self):
        """
        **[Required]** Gets the container of this AzureDataLakeStorageIcebergStorage.
        The Azure Blob Storage container where Iceberg tables are stored.


        :return: The container of this AzureDataLakeStorageIcebergStorage.
        :rtype: str
        """
        return self._container

    @container.setter
    def container(self, container):
        """
        Sets the container of this AzureDataLakeStorageIcebergStorage.
        The Azure Blob Storage container where Iceberg tables are stored.


        :param container: The container of this AzureDataLakeStorageIcebergStorage.
        :type: str
        """
        self._container = container

    @property
    def account_key_secret_id(self):
        """
        **[Required]** Gets the account_key_secret_id of this AzureDataLakeStorageIcebergStorage.
        The `OCID`__ of the Secret where the account key is stored.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The account_key_secret_id of this AzureDataLakeStorageIcebergStorage.
        :rtype: str
        """
        return self._account_key_secret_id

    @account_key_secret_id.setter
    def account_key_secret_id(self, account_key_secret_id):
        """
        Sets the account_key_secret_id of this AzureDataLakeStorageIcebergStorage.
        The `OCID`__ of the Secret where the account key is stored.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param account_key_secret_id: The account_key_secret_id of this AzureDataLakeStorageIcebergStorage.
        :type: str
        """
        self._account_key_secret_id = account_key_secret_id

    @property
    def endpoint(self):
        """
        Gets the endpoint of this AzureDataLakeStorageIcebergStorage.
        The Azure Blob Storage endpoint where Iceberg data is stored.
        e.g.: 'https://my-azure-storage-account.blob.core.windows.net'


        :return: The endpoint of this AzureDataLakeStorageIcebergStorage.
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """
        Sets the endpoint of this AzureDataLakeStorageIcebergStorage.
        The Azure Blob Storage endpoint where Iceberg data is stored.
        e.g.: 'https://my-azure-storage-account.blob.core.windows.net'


        :param endpoint: The endpoint of this AzureDataLakeStorageIcebergStorage.
        :type: str
        """
        self._endpoint = endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
