# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .update_iceberg_catalog_details import UpdateIcebergCatalogDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateNessieIcebergCatalogDetails(UpdateIcebergCatalogDetails):
    """
    The information to update a Nessie catalog used in the Iceberg connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateNessieIcebergCatalogDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.UpdateNessieIcebergCatalogDetails.catalog_type` attribute
        of this class is ``NESSIE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param catalog_type:
            The value to assign to the catalog_type property of this UpdateNessieIcebergCatalogDetails.
            Allowed values for this property are: "GLUE", "HADOOP", "NESSIE", "POLARIS", "REST"
        :type catalog_type: str

        :param uri:
            The value to assign to the uri property of this UpdateNessieIcebergCatalogDetails.
        :type uri: str

        :param branch:
            The value to assign to the branch property of this UpdateNessieIcebergCatalogDetails.
        :type branch: str

        """
        self.swagger_types = {
            'catalog_type': 'str',
            'uri': 'str',
            'branch': 'str'
        }
        self.attribute_map = {
            'catalog_type': 'catalogType',
            'uri': 'uri',
            'branch': 'branch'
        }
        self._catalog_type = None
        self._uri = None
        self._branch = None
        self._catalog_type = 'NESSIE'

    @property
    def uri(self):
        """
        Gets the uri of this UpdateNessieIcebergCatalogDetails.
        Nessie URI.
        e.g.: 'http://<nessie-server>.com:10001/api/v2'


        :return: The uri of this UpdateNessieIcebergCatalogDetails.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this UpdateNessieIcebergCatalogDetails.
        Nessie URI.
        e.g.: 'http://<nessie-server>.com:10001/api/v2'


        :param uri: The uri of this UpdateNessieIcebergCatalogDetails.
        :type: str
        """
        self._uri = uri

    @property
    def branch(self):
        """
        Gets the branch of this UpdateNessieIcebergCatalogDetails.
        The active branch of the Nessie catalog from which Iceberg reads and writes table metadata.


        :return: The branch of this UpdateNessieIcebergCatalogDetails.
        :rtype: str
        """
        return self._branch

    @branch.setter
    def branch(self, branch):
        """
        Sets the branch of this UpdateNessieIcebergCatalogDetails.
        The active branch of the Nessie catalog from which Iceberg reads and writes table metadata.


        :param branch: The branch of this UpdateNessieIcebergCatalogDetails.
        :type: str
        """
        self._branch = branch

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
