# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddOracleManagedCustomEndpointDetails(object):
    """
    Details for enabling Oracle Managed custom endpoint
    """

    #: A constant which can be used with the dns_type property of a AddOracleManagedCustomEndpointDetails.
    #: This constant has a value of "OCI"
    DNS_TYPE_OCI = "OCI"

    def __init__(self, **kwargs):
        """
        Initializes a new AddOracleManagedCustomEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param hostname:
            The value to assign to the hostname property of this AddOracleManagedCustomEndpointDetails.
        :type hostname: str

        :param dns_type:
            The value to assign to the dns_type property of this AddOracleManagedCustomEndpointDetails.
            Allowed values for this property are: "OCI"
        :type dns_type: str

        :param dns_zone_name:
            The value to assign to the dns_zone_name property of this AddOracleManagedCustomEndpointDetails.
        :type dns_zone_name: str

        """
        self.swagger_types = {
            'hostname': 'str',
            'dns_type': 'str',
            'dns_zone_name': 'str'
        }
        self.attribute_map = {
            'hostname': 'hostname',
            'dns_type': 'dnsType',
            'dns_zone_name': 'dnsZoneName'
        }
        self._hostname = None
        self._dns_type = None
        self._dns_zone_name = None

    @property
    def hostname(self):
        """
        **[Required]** Gets the hostname of this AddOracleManagedCustomEndpointDetails.
        Oracle managed custom hostname


        :return: The hostname of this AddOracleManagedCustomEndpointDetails.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this AddOracleManagedCustomEndpointDetails.
        Oracle managed custom hostname


        :param hostname: The hostname of this AddOracleManagedCustomEndpointDetails.
        :type: str
        """
        self._hostname = hostname

    @property
    def dns_type(self):
        """
        Gets the dns_type of this AddOracleManagedCustomEndpointDetails.
        Type of DNS.

        Allowed values for this property are: "OCI"


        :return: The dns_type of this AddOracleManagedCustomEndpointDetails.
        :rtype: str
        """
        return self._dns_type

    @dns_type.setter
    def dns_type(self, dns_type):
        """
        Sets the dns_type of this AddOracleManagedCustomEndpointDetails.
        Type of DNS.


        :param dns_type: The dns_type of this AddOracleManagedCustomEndpointDetails.
        :type: str
        """
        allowed_values = ["OCI"]
        if not value_allowed_none_or_none_sentinel(dns_type, allowed_values):
            raise ValueError(
                f"Invalid value for `dns_type`, must be None or one of {allowed_values}"
            )
        self._dns_type = dns_type

    @property
    def dns_zone_name(self):
        """
        Gets the dns_zone_name of this AddOracleManagedCustomEndpointDetails.
        DNS Zone name


        :return: The dns_zone_name of this AddOracleManagedCustomEndpointDetails.
        :rtype: str
        """
        return self._dns_zone_name

    @dns_zone_name.setter
    def dns_zone_name(self, dns_zone_name):
        """
        Sets the dns_zone_name of this AddOracleManagedCustomEndpointDetails.
        DNS Zone name


        :param dns_zone_name: The dns_zone_name of this AddOracleManagedCustomEndpointDetails.
        :type: str
        """
        self._dns_zone_name = dns_zone_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
