# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinRelationship(object):
    """
    A digital twin relationship represents an association between two digital twin instances.
    It can include properties to describe the nature and context of the association within the IoT domain.

    To use any API operations, you must be authorized in an IAM policy. If you are not authorized, contact an administrator.
    If you are an administrator who needs to create policies to grant users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a DigitalTwinRelationship.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DigitalTwinRelationship.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinRelationship object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DigitalTwinRelationship.
        :type id: str

        :param iot_domain_id:
            The value to assign to the iot_domain_id property of this DigitalTwinRelationship.
        :type iot_domain_id: str

        :param display_name:
            The value to assign to the display_name property of this DigitalTwinRelationship.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DigitalTwinRelationship.
        :type description: str

        :param content_path:
            The value to assign to the content_path property of this DigitalTwinRelationship.
        :type content_path: str

        :param source_digital_twin_instance_id:
            The value to assign to the source_digital_twin_instance_id property of this DigitalTwinRelationship.
        :type source_digital_twin_instance_id: str

        :param target_digital_twin_instance_id:
            The value to assign to the target_digital_twin_instance_id property of this DigitalTwinRelationship.
        :type target_digital_twin_instance_id: str

        :param content:
            The value to assign to the content property of this DigitalTwinRelationship.
        :type content: dict(str, object)

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DigitalTwinRelationship.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DigitalTwinRelationship.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DigitalTwinRelationship.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DigitalTwinRelationship.
        :type system_tags: dict(str, dict(str, object))

        :param time_created:
            The value to assign to the time_created property of this DigitalTwinRelationship.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DigitalTwinRelationship.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'iot_domain_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'content_path': 'str',
            'source_digital_twin_instance_id': 'str',
            'target_digital_twin_instance_id': 'str',
            'content': 'dict(str, object)',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'iot_domain_id': 'iotDomainId',
            'display_name': 'displayName',
            'description': 'description',
            'content_path': 'contentPath',
            'source_digital_twin_instance_id': 'sourceDigitalTwinInstanceId',
            'target_digital_twin_instance_id': 'targetDigitalTwinInstanceId',
            'content': 'content',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._iot_domain_id = None
        self._display_name = None
        self._description = None
        self._content_path = None
        self._source_digital_twin_instance_id = None
        self._target_digital_twin_instance_id = None
        self._content = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DigitalTwinRelationship.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DigitalTwinRelationship.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this DigitalTwinRelationship.
        :type: str
        """
        self._id = id

    @property
    def iot_domain_id(self):
        """
        **[Required]** Gets the iot_domain_id of this DigitalTwinRelationship.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The iot_domain_id of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._iot_domain_id

    @iot_domain_id.setter
    def iot_domain_id(self, iot_domain_id):
        """
        Sets the iot_domain_id of this DigitalTwinRelationship.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param iot_domain_id: The iot_domain_id of this DigitalTwinRelationship.
        :type: str
        """
        self._iot_domain_id = iot_domain_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DigitalTwinRelationship.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DigitalTwinRelationship.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this DigitalTwinRelationship.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DigitalTwinRelationship.
        A short description of the resource.


        :return: The description of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DigitalTwinRelationship.
        A short description of the resource.


        :param description: The description of this DigitalTwinRelationship.
        :type: str
        """
        self._description = description

    @property
    def content_path(self):
        """
        **[Required]** Gets the content_path of this DigitalTwinRelationship.
        Its the name of the relationship that links two digital twin instances. Here, it is the relationship name of the source digital twin model.


        :return: The content_path of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._content_path

    @content_path.setter
    def content_path(self, content_path):
        """
        Sets the content_path of this DigitalTwinRelationship.
        Its the name of the relationship that links two digital twin instances. Here, it is the relationship name of the source digital twin model.


        :param content_path: The content_path of this DigitalTwinRelationship.
        :type: str
        """
        self._content_path = content_path

    @property
    def source_digital_twin_instance_id(self):
        """
        **[Required]** Gets the source_digital_twin_instance_id of this DigitalTwinRelationship.
        The `OCID`__ of source digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The source_digital_twin_instance_id of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._source_digital_twin_instance_id

    @source_digital_twin_instance_id.setter
    def source_digital_twin_instance_id(self, source_digital_twin_instance_id):
        """
        Sets the source_digital_twin_instance_id of this DigitalTwinRelationship.
        The `OCID`__ of source digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param source_digital_twin_instance_id: The source_digital_twin_instance_id of this DigitalTwinRelationship.
        :type: str
        """
        self._source_digital_twin_instance_id = source_digital_twin_instance_id

    @property
    def target_digital_twin_instance_id(self):
        """
        **[Required]** Gets the target_digital_twin_instance_id of this DigitalTwinRelationship.
        The `OCID`__ of target digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The target_digital_twin_instance_id of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._target_digital_twin_instance_id

    @target_digital_twin_instance_id.setter
    def target_digital_twin_instance_id(self, target_digital_twin_instance_id):
        """
        Sets the target_digital_twin_instance_id of this DigitalTwinRelationship.
        The `OCID`__ of target digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param target_digital_twin_instance_id: The target_digital_twin_instance_id of this DigitalTwinRelationship.
        :type: str
        """
        self._target_digital_twin_instance_id = target_digital_twin_instance_id

    @property
    def content(self):
        """
        Gets the content of this DigitalTwinRelationship.
        The value(s) of the relationship properties defined in the source digital twin model.


        :return: The content of this DigitalTwinRelationship.
        :rtype: dict(str, object)
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this DigitalTwinRelationship.
        The value(s) of the relationship properties defined in the source digital twin model.


        :param content: The content of this DigitalTwinRelationship.
        :type: dict(str, object)
        """
        self._content = content

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DigitalTwinRelationship.
        The current state of the digital twin relationship.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DigitalTwinRelationship.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DigitalTwinRelationship.
        The current state of the digital twin relationship.


        :param lifecycle_state: The lifecycle_state of this DigitalTwinRelationship.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DigitalTwinRelationship.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DigitalTwinRelationship.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DigitalTwinRelationship.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DigitalTwinRelationship.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DigitalTwinRelationship.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DigitalTwinRelationship.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DigitalTwinRelationship.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DigitalTwinRelationship.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DigitalTwinRelationship.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DigitalTwinRelationship.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DigitalTwinRelationship.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DigitalTwinRelationship.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DigitalTwinRelationship.
        The date and time when the resource was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DigitalTwinRelationship.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DigitalTwinRelationship.
        The date and time when the resource was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DigitalTwinRelationship.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DigitalTwinRelationship.
        The date and time when the resource was last updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this DigitalTwinRelationship.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DigitalTwinRelationship.
        The date and time when the resource was last updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this DigitalTwinRelationship.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
