# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ClusterDetails(object):
    """
    The state of the cluster during a specified time period.
    """

    #: A constant which can be used with the cluster_type property of a ClusterDetails.
    #: This constant has a value of "OKE"
    CLUSTER_TYPE_OKE = "OKE"

    #: A constant which can be used with the cluster_type property of a ClusterDetails.
    #: This constant has a value of "OTHER"
    CLUSTER_TYPE_OTHER = "OTHER"

    def __init__(self, **kwargs):
        """
        Initializes a new ClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_type:
            The value to assign to the cluster_type property of this ClusterDetails.
            Allowed values for this property are: "OKE", "OTHER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cluster_type: str

        :param node_count:
            The value to assign to the node_count property of this ClusterDetails.
        :type node_count: int

        :param pod_count:
            The value to assign to the pod_count property of this ClusterDetails.
        :type pod_count: int

        :param container_count:
            The value to assign to the container_count property of this ClusterDetails.
        :type container_count: int

        """
        self.swagger_types = {
            'cluster_type': 'str',
            'node_count': 'int',
            'pod_count': 'int',
            'container_count': 'int'
        }
        self.attribute_map = {
            'cluster_type': 'clusterType',
            'node_count': 'nodeCount',
            'pod_count': 'podCount',
            'container_count': 'containerCount'
        }
        self._cluster_type = None
        self._node_count = None
        self._pod_count = None
        self._container_count = None

    @property
    def cluster_type(self):
        """
        Gets the cluster_type of this ClusterDetails.
        The type of the cluster.

        Allowed values for this property are: "OKE", "OTHER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cluster_type of this ClusterDetails.
        :rtype: str
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """
        Sets the cluster_type of this ClusterDetails.
        The type of the cluster.


        :param cluster_type: The cluster_type of this ClusterDetails.
        :type: str
        """
        allowed_values = ["OKE", "OTHER"]
        if not value_allowed_none_or_none_sentinel(cluster_type, allowed_values):
            cluster_type = 'UNKNOWN_ENUM_VALUE'
        self._cluster_type = cluster_type

    @property
    def node_count(self):
        """
        Gets the node_count of this ClusterDetails.
        Number of nodes as reported in the last cluster scan


        :return: The node_count of this ClusterDetails.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this ClusterDetails.
        Number of nodes as reported in the last cluster scan


        :param node_count: The node_count of this ClusterDetails.
        :type: int
        """
        self._node_count = node_count

    @property
    def pod_count(self):
        """
        Gets the pod_count of this ClusterDetails.
        Number of pods as reported in the last cluster scan


        :return: The pod_count of this ClusterDetails.
        :rtype: int
        """
        return self._pod_count

    @pod_count.setter
    def pod_count(self, pod_count):
        """
        Sets the pod_count of this ClusterDetails.
        Number of pods as reported in the last cluster scan


        :param pod_count: The pod_count of this ClusterDetails.
        :type: int
        """
        self._pod_count = pod_count

    @property
    def container_count(self):
        """
        Gets the container_count of this ClusterDetails.
        Number of containers as reported in the last cluster scan


        :return: The container_count of this ClusterDetails.
        :rtype: int
        """
        return self._container_count

    @container_count.setter
    def container_count(self, container_count):
        """
        Sets the container_count of this ClusterDetails.
        Number of containers as reported in the last cluster scan


        :param container_count: The container_count of this ClusterDetails.
        :type: int
        """
        self._container_count = container_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
