# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PluginErrorAggregation(object):
    """
    Aggregation of PluginErrors
    """

    #: A constant which can be used with the reason property of a PluginErrorAggregation.
    #: This constant has a value of "REGISTRATION_POLICY"
    REASON_REGISTRATION_POLICY = "REGISTRATION_POLICY"

    #: A constant which can be used with the reason property of a PluginErrorAggregation.
    #: This constant has a value of "LOG_RESOURCE_POLICY"
    REASON_LOG_RESOURCE_POLICY = "LOG_RESOURCE_POLICY"

    #: A constant which can be used with the reason property of a PluginErrorAggregation.
    #: This constant has a value of "NO_FLEET"
    REASON_NO_FLEET = "NO_FLEET"

    def __init__(self, **kwargs):
        """
        Initializes a new PluginErrorAggregation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reason:
            The value to assign to the reason property of this PluginErrorAggregation.
            Allowed values for this property are: "REGISTRATION_POLICY", "LOG_RESOURCE_POLICY", "NO_FLEET", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type reason: str

        :param count:
            The value to assign to the count property of this PluginErrorAggregation.
        :type count: int

        """
        self.swagger_types = {
            'reason': 'str',
            'count': 'int'
        }
        self.attribute_map = {
            'reason': 'reason',
            'count': 'count'
        }
        self._reason = None
        self._count = None

    @property
    def reason(self):
        """
        **[Required]** Gets the reason of this PluginErrorAggregation.
        Enum that uniquely identifies the plugin error.

        Allowed values for this property are: "REGISTRATION_POLICY", "LOG_RESOURCE_POLICY", "NO_FLEET", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The reason of this PluginErrorAggregation.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """
        Sets the reason of this PluginErrorAggregation.
        Enum that uniquely identifies the plugin error.


        :param reason: The reason of this PluginErrorAggregation.
        :type: str
        """
        allowed_values = ["REGISTRATION_POLICY", "LOG_RESOURCE_POLICY", "NO_FLEET"]
        if not value_allowed_none_or_none_sentinel(reason, allowed_values):
            reason = 'UNKNOWN_ENUM_VALUE'
        self._reason = reason

    @property
    def count(self):
        """
        **[Required]** Gets the count of this PluginErrorAggregation.
        Number of FleetErrors encountered for the specific reason.


        :return: The count of this PluginErrorAggregation.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this PluginErrorAggregation.
        Number of FleetErrors encountered for the specific reason.


        :param count: The count of this PluginErrorAggregation.
        :type: int
        """
        self._count = count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
