# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AbstractParserTestResultLogEntry(object):
    """
    AbstractParserTestResultLogEntry
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AbstractParserTestResultLogEntry object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param extra_info_attributes:
            The value to assign to the extra_info_attributes property of this AbstractParserTestResultLogEntry.
        :type extra_info_attributes: dict(str, str)

        :param field_map:
            The value to assign to the field_map property of this AbstractParserTestResultLogEntry.
        :type field_map: dict(str, str)

        :param field_name_value_map:
            The value to assign to the field_name_value_map property of this AbstractParserTestResultLogEntry.
        :type field_name_value_map: dict(str, str)

        :param field_position_value_map:
            The value to assign to the field_position_value_map property of this AbstractParserTestResultLogEntry.
        :type field_position_value_map: dict(str, str)

        :param fields:
            The value to assign to the fields property of this AbstractParserTestResultLogEntry.
        :type fields: dict(str, str)

        :param log_entry:
            The value to assign to the log_entry property of this AbstractParserTestResultLogEntry.
        :type log_entry: str

        :param match_status:
            The value to assign to the match_status property of this AbstractParserTestResultLogEntry.
        :type match_status: str

        :param match_status_description:
            The value to assign to the match_status_description property of this AbstractParserTestResultLogEntry.
        :type match_status_description: str

        :param field_mapping:
            The value to assign to the field_mapping property of this AbstractParserTestResultLogEntry.
        :type field_mapping: list[oci.log_analytics.models.ParserTestResultFieldValue]

        :param metadata:
            The value to assign to the metadata property of this AbstractParserTestResultLogEntry.
        :type metadata: list[oci.log_analytics.models.ParserTestResultFieldValue]

        :param action:
            The value to assign to the action property of this AbstractParserTestResultLogEntry.
        :type action: str

        :param timestamp_zone:
            The value to assign to the timestamp_zone property of this AbstractParserTestResultLogEntry.
        :type timestamp_zone: str

        :param timestamp_start_index:
            The value to assign to the timestamp_start_index property of this AbstractParserTestResultLogEntry.
        :type timestamp_start_index: int

        :param timestamp_end_index:
            The value to assign to the timestamp_end_index property of this AbstractParserTestResultLogEntry.
        :type timestamp_end_index: int

        :param timestamp_epoch_millisec:
            The value to assign to the timestamp_epoch_millisec property of this AbstractParserTestResultLogEntry.
        :type timestamp_epoch_millisec: int

        :param text_match_info:
            The value to assign to the text_match_info property of this AbstractParserTestResultLogEntry.
        :type text_match_info: oci.log_analytics.models.AbstractParserTestResultLogLine

        :param match_result:
            The value to assign to the match_result property of this AbstractParserTestResultLogEntry.
        :type match_result: oci.log_analytics.models.RegexMatchResult

        :param loglines:
            The value to assign to the loglines property of this AbstractParserTestResultLogEntry.
        :type loglines: list[oci.log_analytics.models.AbstractParserTestResultLogLine]

        :param function_names:
            The value to assign to the function_names property of this AbstractParserTestResultLogEntry.
        :type function_names: list[str]

        """
        self.swagger_types = {
            'extra_info_attributes': 'dict(str, str)',
            'field_map': 'dict(str, str)',
            'field_name_value_map': 'dict(str, str)',
            'field_position_value_map': 'dict(str, str)',
            'fields': 'dict(str, str)',
            'log_entry': 'str',
            'match_status': 'str',
            'match_status_description': 'str',
            'field_mapping': 'list[ParserTestResultFieldValue]',
            'metadata': 'list[ParserTestResultFieldValue]',
            'action': 'str',
            'timestamp_zone': 'str',
            'timestamp_start_index': 'int',
            'timestamp_end_index': 'int',
            'timestamp_epoch_millisec': 'int',
            'text_match_info': 'AbstractParserTestResultLogLine',
            'match_result': 'RegexMatchResult',
            'loglines': 'list[AbstractParserTestResultLogLine]',
            'function_names': 'list[str]'
        }
        self.attribute_map = {
            'extra_info_attributes': 'extraInfoAttributes',
            'field_map': 'fieldMap',
            'field_name_value_map': 'fieldNameValueMap',
            'field_position_value_map': 'fieldPositionValueMap',
            'fields': 'fields',
            'log_entry': 'logEntry',
            'match_status': 'matchStatus',
            'match_status_description': 'matchStatusDescription',
            'field_mapping': 'fieldMapping',
            'metadata': 'metadata',
            'action': 'action',
            'timestamp_zone': 'timestampZone',
            'timestamp_start_index': 'timestampStartIndex',
            'timestamp_end_index': 'timestampEndIndex',
            'timestamp_epoch_millisec': 'timestampEpochMillisec',
            'text_match_info': 'textMatchInfo',
            'match_result': 'matchResult',
            'loglines': 'loglines',
            'function_names': 'functionNames'
        }
        self._extra_info_attributes = None
        self._field_map = None
        self._field_name_value_map = None
        self._field_position_value_map = None
        self._fields = None
        self._log_entry = None
        self._match_status = None
        self._match_status_description = None
        self._field_mapping = None
        self._metadata = None
        self._action = None
        self._timestamp_zone = None
        self._timestamp_start_index = None
        self._timestamp_end_index = None
        self._timestamp_epoch_millisec = None
        self._text_match_info = None
        self._match_result = None
        self._loglines = None
        self._function_names = None

    @property
    def extra_info_attributes(self):
        """
        Gets the extra_info_attributes of this AbstractParserTestResultLogEntry.
        Extra information attributes.


        :return: The extra_info_attributes of this AbstractParserTestResultLogEntry.
        :rtype: dict(str, str)
        """
        return self._extra_info_attributes

    @extra_info_attributes.setter
    def extra_info_attributes(self, extra_info_attributes):
        """
        Sets the extra_info_attributes of this AbstractParserTestResultLogEntry.
        Extra information attributes.


        :param extra_info_attributes: The extra_info_attributes of this AbstractParserTestResultLogEntry.
        :type: dict(str, str)
        """
        self._extra_info_attributes = extra_info_attributes

    @property
    def field_map(self):
        """
        Gets the field_map of this AbstractParserTestResultLogEntry.
        The field map.


        :return: The field_map of this AbstractParserTestResultLogEntry.
        :rtype: dict(str, str)
        """
        return self._field_map

    @field_map.setter
    def field_map(self, field_map):
        """
        Sets the field_map of this AbstractParserTestResultLogEntry.
        The field map.


        :param field_map: The field_map of this AbstractParserTestResultLogEntry.
        :type: dict(str, str)
        """
        self._field_map = field_map

    @property
    def field_name_value_map(self):
        """
        Gets the field_name_value_map of this AbstractParserTestResultLogEntry.
        The field name value map.


        :return: The field_name_value_map of this AbstractParserTestResultLogEntry.
        :rtype: dict(str, str)
        """
        return self._field_name_value_map

    @field_name_value_map.setter
    def field_name_value_map(self, field_name_value_map):
        """
        Sets the field_name_value_map of this AbstractParserTestResultLogEntry.
        The field name value map.


        :param field_name_value_map: The field_name_value_map of this AbstractParserTestResultLogEntry.
        :type: dict(str, str)
        """
        self._field_name_value_map = field_name_value_map

    @property
    def field_position_value_map(self):
        """
        Gets the field_position_value_map of this AbstractParserTestResultLogEntry.
        The field position value map.


        :return: The field_position_value_map of this AbstractParserTestResultLogEntry.
        :rtype: dict(str, str)
        """
        return self._field_position_value_map

    @field_position_value_map.setter
    def field_position_value_map(self, field_position_value_map):
        """
        Sets the field_position_value_map of this AbstractParserTestResultLogEntry.
        The field position value map.


        :param field_position_value_map: The field_position_value_map of this AbstractParserTestResultLogEntry.
        :type: dict(str, str)
        """
        self._field_position_value_map = field_position_value_map

    @property
    def fields(self):
        """
        Gets the fields of this AbstractParserTestResultLogEntry.
        The parser fields.


        :return: The fields of this AbstractParserTestResultLogEntry.
        :rtype: dict(str, str)
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this AbstractParserTestResultLogEntry.
        The parser fields.


        :param fields: The fields of this AbstractParserTestResultLogEntry.
        :type: dict(str, str)
        """
        self._fields = fields

    @property
    def log_entry(self):
        """
        Gets the log_entry of this AbstractParserTestResultLogEntry.
        The log entry.


        :return: The log_entry of this AbstractParserTestResultLogEntry.
        :rtype: str
        """
        return self._log_entry

    @log_entry.setter
    def log_entry(self, log_entry):
        """
        Sets the log_entry of this AbstractParserTestResultLogEntry.
        The log entry.


        :param log_entry: The log_entry of this AbstractParserTestResultLogEntry.
        :type: str
        """
        self._log_entry = log_entry

    @property
    def match_status(self):
        """
        Gets the match_status of this AbstractParserTestResultLogEntry.
        The match status.


        :return: The match_status of this AbstractParserTestResultLogEntry.
        :rtype: str
        """
        return self._match_status

    @match_status.setter
    def match_status(self, match_status):
        """
        Sets the match_status of this AbstractParserTestResultLogEntry.
        The match status.


        :param match_status: The match_status of this AbstractParserTestResultLogEntry.
        :type: str
        """
        self._match_status = match_status

    @property
    def match_status_description(self):
        """
        Gets the match_status_description of this AbstractParserTestResultLogEntry.
        The match status description.


        :return: The match_status_description of this AbstractParserTestResultLogEntry.
        :rtype: str
        """
        return self._match_status_description

    @match_status_description.setter
    def match_status_description(self, match_status_description):
        """
        Sets the match_status_description of this AbstractParserTestResultLogEntry.
        The match status description.


        :param match_status_description: The match_status_description of this AbstractParserTestResultLogEntry.
        :type: str
        """
        self._match_status_description = match_status_description

    @property
    def field_mapping(self):
        """
        Gets the field_mapping of this AbstractParserTestResultLogEntry.
        Additional properties on the field map.


        :return: The field_mapping of this AbstractParserTestResultLogEntry.
        :rtype: list[oci.log_analytics.models.ParserTestResultFieldValue]
        """
        return self._field_mapping

    @field_mapping.setter
    def field_mapping(self, field_mapping):
        """
        Sets the field_mapping of this AbstractParserTestResultLogEntry.
        Additional properties on the field map.


        :param field_mapping: The field_mapping of this AbstractParserTestResultLogEntry.
        :type: list[oci.log_analytics.models.ParserTestResultFieldValue]
        """
        self._field_mapping = field_mapping

    @property
    def metadata(self):
        """
        Gets the metadata of this AbstractParserTestResultLogEntry.
        Additional properties on the field map if sub parser with actions defined.


        :return: The metadata of this AbstractParserTestResultLogEntry.
        :rtype: list[oci.log_analytics.models.ParserTestResultFieldValue]
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this AbstractParserTestResultLogEntry.
        Additional properties on the field map if sub parser with actions defined.


        :param metadata: The metadata of this AbstractParserTestResultLogEntry.
        :type: list[oci.log_analytics.models.ParserTestResultFieldValue]
        """
        self._metadata = metadata

    @property
    def action(self):
        """
        Gets the action of this AbstractParserTestResultLogEntry.
        The parser action.


        :return: The action of this AbstractParserTestResultLogEntry.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this AbstractParserTestResultLogEntry.
        The parser action.


        :param action: The action of this AbstractParserTestResultLogEntry.
        :type: str
        """
        self._action = action

    @property
    def timestamp_zone(self):
        """
        Gets the timestamp_zone of this AbstractParserTestResultLogEntry.
        The timezone corresponding to the timestamp detected in the log entry (e.g. GMT).


        :return: The timestamp_zone of this AbstractParserTestResultLogEntry.
        :rtype: str
        """
        return self._timestamp_zone

    @timestamp_zone.setter
    def timestamp_zone(self, timestamp_zone):
        """
        Sets the timestamp_zone of this AbstractParserTestResultLogEntry.
        The timezone corresponding to the timestamp detected in the log entry (e.g. GMT).


        :param timestamp_zone: The timestamp_zone of this AbstractParserTestResultLogEntry.
        :type: str
        """
        self._timestamp_zone = timestamp_zone

    @property
    def timestamp_start_index(self):
        """
        Gets the timestamp_start_index of this AbstractParserTestResultLogEntry.
        In case of regex parser, if there is any timestamp identified in the log entry,
        this value signifies the index in the log entry from which timestamp starts.


        :return: The timestamp_start_index of this AbstractParserTestResultLogEntry.
        :rtype: int
        """
        return self._timestamp_start_index

    @timestamp_start_index.setter
    def timestamp_start_index(self, timestamp_start_index):
        """
        Sets the timestamp_start_index of this AbstractParserTestResultLogEntry.
        In case of regex parser, if there is any timestamp identified in the log entry,
        this value signifies the index in the log entry from which timestamp starts.


        :param timestamp_start_index: The timestamp_start_index of this AbstractParserTestResultLogEntry.
        :type: int
        """
        self._timestamp_start_index = timestamp_start_index

    @property
    def timestamp_end_index(self):
        """
        Gets the timestamp_end_index of this AbstractParserTestResultLogEntry.
        In case of regex parser, if there is any timestamp identified in the log entry,
        this value signifies the index in the log entry at which timestamp ends.


        :return: The timestamp_end_index of this AbstractParserTestResultLogEntry.
        :rtype: int
        """
        return self._timestamp_end_index

    @timestamp_end_index.setter
    def timestamp_end_index(self, timestamp_end_index):
        """
        Sets the timestamp_end_index of this AbstractParserTestResultLogEntry.
        In case of regex parser, if there is any timestamp identified in the log entry,
        this value signifies the index in the log entry at which timestamp ends.


        :param timestamp_end_index: The timestamp_end_index of this AbstractParserTestResultLogEntry.
        :type: int
        """
        self._timestamp_end_index = timestamp_end_index

    @property
    def timestamp_epoch_millisec(self):
        """
        Gets the timestamp_epoch_millisec of this AbstractParserTestResultLogEntry.
        The timestamp epoch in milliseconds.


        :return: The timestamp_epoch_millisec of this AbstractParserTestResultLogEntry.
        :rtype: int
        """
        return self._timestamp_epoch_millisec

    @timestamp_epoch_millisec.setter
    def timestamp_epoch_millisec(self, timestamp_epoch_millisec):
        """
        Sets the timestamp_epoch_millisec of this AbstractParserTestResultLogEntry.
        The timestamp epoch in milliseconds.


        :param timestamp_epoch_millisec: The timestamp_epoch_millisec of this AbstractParserTestResultLogEntry.
        :type: int
        """
        self._timestamp_epoch_millisec = timestamp_epoch_millisec

    @property
    def text_match_info(self):
        """
        Gets the text_match_info of this AbstractParserTestResultLogEntry.

        :return: The text_match_info of this AbstractParserTestResultLogEntry.
        :rtype: oci.log_analytics.models.AbstractParserTestResultLogLine
        """
        return self._text_match_info

    @text_match_info.setter
    def text_match_info(self, text_match_info):
        """
        Sets the text_match_info of this AbstractParserTestResultLogEntry.

        :param text_match_info: The text_match_info of this AbstractParserTestResultLogEntry.
        :type: oci.log_analytics.models.AbstractParserTestResultLogLine
        """
        self._text_match_info = text_match_info

    @property
    def match_result(self):
        """
        Gets the match_result of this AbstractParserTestResultLogEntry.

        :return: The match_result of this AbstractParserTestResultLogEntry.
        :rtype: oci.log_analytics.models.RegexMatchResult
        """
        return self._match_result

    @match_result.setter
    def match_result(self, match_result):
        """
        Sets the match_result of this AbstractParserTestResultLogEntry.

        :param match_result: The match_result of this AbstractParserTestResultLogEntry.
        :type: oci.log_analytics.models.RegexMatchResult
        """
        self._match_result = match_result

    @property
    def loglines(self):
        """
        Gets the loglines of this AbstractParserTestResultLogEntry.
        Test result log lines.


        :return: The loglines of this AbstractParserTestResultLogEntry.
        :rtype: list[oci.log_analytics.models.AbstractParserTestResultLogLine]
        """
        return self._loglines

    @loglines.setter
    def loglines(self, loglines):
        """
        Sets the loglines of this AbstractParserTestResultLogEntry.
        Test result log lines.


        :param loglines: The loglines of this AbstractParserTestResultLogEntry.
        :type: list[oci.log_analytics.models.AbstractParserTestResultLogLine]
        """
        self._loglines = loglines

    @property
    def function_names(self):
        """
        Gets the function_names of this AbstractParserTestResultLogEntry.
        The parser function names.


        :return: The function_names of this AbstractParserTestResultLogEntry.
        :rtype: list[str]
        """
        return self._function_names

    @function_names.setter
    def function_names(self, function_names):
        """
        Sets the function_names of this AbstractParserTestResultLogEntry.
        The parser function names.


        :param function_names: The function_names of this AbstractParserTestResultLogEntry.
        :type: list[str]
        """
        self._function_names = function_names

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
