# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricCollection(object):
    """
    Metric collection specification.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this MetricCollection.
        :type metric_name: str

        :param query_table_name:
            The value to assign to the query_table_name property of this MetricCollection.
        :type query_table_name: str

        :param metric_query_field_name:
            The value to assign to the metric_query_field_name property of this MetricCollection.
        :type metric_query_field_name: str

        :param dimensions:
            The value to assign to the dimensions property of this MetricCollection.
        :type dimensions: list[oci.log_analytics.models.DimensionField]

        """
        self.swagger_types = {
            'metric_name': 'str',
            'query_table_name': 'str',
            'metric_query_field_name': 'str',
            'dimensions': 'list[DimensionField]'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'query_table_name': 'queryTableName',
            'metric_query_field_name': 'metricQueryFieldName',
            'dimensions': 'dimensions'
        }
        self._metric_name = None
        self._query_table_name = None
        self._metric_query_field_name = None
        self._dimensions = None

    @property
    def metric_name(self):
        """
        **[Required]** Gets the metric_name of this MetricCollection.
        The metric name for this metric collection.
        A valid value starts with an alphabetical character and includes only
        alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).


        :return: The metric_name of this MetricCollection.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this MetricCollection.
        The metric name for this metric collection.
        A valid value starts with an alphabetical character and includes only
        alphanumeric characters, periods (.), underscores (_), hyphens (-), and dollar signs ($).


        :param metric_name: The metric_name of this MetricCollection.
        :type: str
        """
        self._metric_name = metric_name

    @property
    def query_table_name(self):
        """
        Gets the query_table_name of this MetricCollection.
        Output table in the query.


        :return: The query_table_name of this MetricCollection.
        :rtype: str
        """
        return self._query_table_name

    @query_table_name.setter
    def query_table_name(self, query_table_name):
        """
        Sets the query_table_name of this MetricCollection.
        Output table in the query.


        :param query_table_name: The query_table_name of this MetricCollection.
        :type: str
        """
        self._query_table_name = query_table_name

    @property
    def metric_query_field_name(self):
        """
        **[Required]** Gets the metric_query_field_name of this MetricCollection.
        Output field in the query to be used as the metric value.


        :return: The metric_query_field_name of this MetricCollection.
        :rtype: str
        """
        return self._metric_query_field_name

    @metric_query_field_name.setter
    def metric_query_field_name(self, metric_query_field_name):
        """
        Sets the metric_query_field_name of this MetricCollection.
        Output field in the query to be used as the metric value.


        :param metric_query_field_name: The metric_query_field_name of this MetricCollection.
        :type: str
        """
        self._metric_query_field_name = metric_query_field_name

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this MetricCollection.
        Selected dimension fields for the metric collection.


        :return: The dimensions of this MetricCollection.
        :rtype: list[oci.log_analytics.models.DimensionField]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this MetricCollection.
        Selected dimension fields for the metric collection.


        :param dimensions: The dimensions of this MetricCollection.
        :type: list[oci.log_analytics.models.DimensionField]
        """
        self._dimensions = dimensions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
