# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateObjectStorageLinkDetails(object):
    """
    The details to create a Object Storage link.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateObjectStorageLinkDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateObjectStorageLinkDetails.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateObjectStorageLinkDetails.
        :type availability_domain: str

        :param display_name:
            The value to assign to the display_name property of this CreateObjectStorageLinkDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateObjectStorageLinkDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateObjectStorageLinkDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param lustre_file_system_id:
            The value to assign to the lustre_file_system_id property of this CreateObjectStorageLinkDetails.
        :type lustre_file_system_id: str

        :param file_system_path:
            The value to assign to the file_system_path property of this CreateObjectStorageLinkDetails.
        :type file_system_path: str

        :param object_storage_prefix:
            The value to assign to the object_storage_prefix property of this CreateObjectStorageLinkDetails.
        :type object_storage_prefix: str

        :param is_overwrite:
            The value to assign to the is_overwrite property of this CreateObjectStorageLinkDetails.
        :type is_overwrite: bool

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'availability_domain': 'str',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'lustre_file_system_id': 'str',
            'file_system_path': 'str',
            'object_storage_prefix': 'str',
            'is_overwrite': 'bool'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'lustre_file_system_id': 'lustreFileSystemId',
            'file_system_path': 'fileSystemPath',
            'object_storage_prefix': 'objectStoragePrefix',
            'is_overwrite': 'isOverwrite'
        }
        self._compartment_id = None
        self._availability_domain = None
        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None
        self._lustre_file_system_id = None
        self._file_system_path = None
        self._object_storage_prefix = None
        self._is_overwrite = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateObjectStorageLinkDetails.
        The `OCID`__ of the compartment that contains the Object Storage link.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateObjectStorageLinkDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateObjectStorageLinkDetails.
        The `OCID`__ of the compartment that contains the Object Storage link.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateObjectStorageLinkDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateObjectStorageLinkDetails.
        The availability domain that the Lustre file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this CreateObjectStorageLinkDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateObjectStorageLinkDetails.
        The availability domain that the Lustre file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this CreateObjectStorageLinkDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateObjectStorageLinkDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Object Storage Link`


        :return: The display_name of this CreateObjectStorageLinkDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateObjectStorageLinkDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Object Storage Link`


        :param display_name: The display_name of this CreateObjectStorageLinkDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateObjectStorageLinkDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateObjectStorageLinkDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateObjectStorageLinkDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateObjectStorageLinkDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateObjectStorageLinkDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateObjectStorageLinkDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateObjectStorageLinkDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateObjectStorageLinkDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def lustre_file_system_id(self):
        """
        **[Required]** Gets the lustre_file_system_id of this CreateObjectStorageLinkDetails.
        The `OCID`__ of the associated Lustre file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The lustre_file_system_id of this CreateObjectStorageLinkDetails.
        :rtype: str
        """
        return self._lustre_file_system_id

    @lustre_file_system_id.setter
    def lustre_file_system_id(self, lustre_file_system_id):
        """
        Sets the lustre_file_system_id of this CreateObjectStorageLinkDetails.
        The `OCID`__ of the associated Lustre file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param lustre_file_system_id: The lustre_file_system_id of this CreateObjectStorageLinkDetails.
        :type: str
        """
        self._lustre_file_system_id = lustre_file_system_id

    @property
    def file_system_path(self):
        """
        **[Required]** Gets the file_system_path of this CreateObjectStorageLinkDetails.
        The path in the Lustre file system used for this Object Storage link.

        Example: `myFileSystem/mount/myDirectory`


        :return: The file_system_path of this CreateObjectStorageLinkDetails.
        :rtype: str
        """
        return self._file_system_path

    @file_system_path.setter
    def file_system_path(self, file_system_path):
        """
        Sets the file_system_path of this CreateObjectStorageLinkDetails.
        The path in the Lustre file system used for this Object Storage link.

        Example: `myFileSystem/mount/myDirectory`


        :param file_system_path: The file_system_path of this CreateObjectStorageLinkDetails.
        :type: str
        """
        self._file_system_path = file_system_path

    @property
    def object_storage_prefix(self):
        """
        **[Required]** Gets the object_storage_prefix of this CreateObjectStorageLinkDetails.
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.

        Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`


        :return: The object_storage_prefix of this CreateObjectStorageLinkDetails.
        :rtype: str
        """
        return self._object_storage_prefix

    @object_storage_prefix.setter
    def object_storage_prefix(self, object_storage_prefix):
        """
        Sets the object_storage_prefix of this CreateObjectStorageLinkDetails.
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.

        Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`


        :param object_storage_prefix: The object_storage_prefix of this CreateObjectStorageLinkDetails.
        :type: str
        """
        self._object_storage_prefix = object_storage_prefix

    @property
    def is_overwrite(self):
        """
        **[Required]** Gets the is_overwrite of this CreateObjectStorageLinkDetails.
        The flag is an identifier to tell whether the job run has overwrite enabled.
        If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists.
        If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.


        :return: The is_overwrite of this CreateObjectStorageLinkDetails.
        :rtype: bool
        """
        return self._is_overwrite

    @is_overwrite.setter
    def is_overwrite(self, is_overwrite):
        """
        Sets the is_overwrite of this CreateObjectStorageLinkDetails.
        The flag is an identifier to tell whether the job run has overwrite enabled.
        If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists.
        If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.


        :param is_overwrite: The is_overwrite of this CreateObjectStorageLinkDetails.
        :type: bool
        """
        self._is_overwrite = is_overwrite

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
