# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KafkaClusterConfigVersion(object):
    """
    A shared configuration object used by 0 or more kafka clusters.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KafkaClusterConfigVersion object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_id:
            The value to assign to the config_id property of this KafkaClusterConfigVersion.
        :type config_id: str

        :param version_number:
            The value to assign to the version_number property of this KafkaClusterConfigVersion.
        :type version_number: int

        :param time_created:
            The value to assign to the time_created property of this KafkaClusterConfigVersion.
        :type time_created: datetime

        :param properties:
            The value to assign to the properties property of this KafkaClusterConfigVersion.
        :type properties: dict(str, str)

        """
        self.swagger_types = {
            'config_id': 'str',
            'version_number': 'int',
            'time_created': 'datetime',
            'properties': 'dict(str, str)'
        }
        self.attribute_map = {
            'config_id': 'configId',
            'version_number': 'versionNumber',
            'time_created': 'timeCreated',
            'properties': 'properties'
        }
        self._config_id = None
        self._version_number = None
        self._time_created = None
        self._properties = None

    @property
    def config_id(self):
        """
        Gets the config_id of this KafkaClusterConfigVersion.
        ID cluster configuration


        :return: The config_id of this KafkaClusterConfigVersion.
        :rtype: str
        """
        return self._config_id

    @config_id.setter
    def config_id(self, config_id):
        """
        Sets the config_id of this KafkaClusterConfigVersion.
        ID cluster configuration


        :param config_id: The config_id of this KafkaClusterConfigVersion.
        :type: str
        """
        self._config_id = config_id

    @property
    def version_number(self):
        """
        Gets the version_number of this KafkaClusterConfigVersion.
        Version of the cluster configuration


        :return: The version_number of this KafkaClusterConfigVersion.
        :rtype: int
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number):
        """
        Sets the version_number of this KafkaClusterConfigVersion.
        Version of the cluster configuration


        :param version_number: The version_number of this KafkaClusterConfigVersion.
        :type: int
        """
        self._version_number = version_number

    @property
    def time_created(self):
        """
        Gets the time_created of this KafkaClusterConfigVersion.
        The date and time the KafkaClusterConfigVersion was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this KafkaClusterConfigVersion.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this KafkaClusterConfigVersion.
        The date and time the KafkaClusterConfigVersion was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this KafkaClusterConfigVersion.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def properties(self):
        """
        **[Required]** Gets the properties of this KafkaClusterConfigVersion.
        Cluster configuration key-value pairs


        :return: The properties of this KafkaClusterConfigVersion.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this KafkaClusterConfigVersion.
        Cluster configuration key-value pairs


        :param properties: The properties of this KafkaClusterConfigVersion.
        :type: dict(str, str)
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
