# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ArtifactSummary(object):
    """
    The model for the artifact summary.
    """

    #: A constant which can be used with the artifact_type property of a ArtifactSummary.
    #: This constant has a value of "CONTAINER_IMAGE"
    ARTIFACT_TYPE_CONTAINER_IMAGE = "CONTAINER_IMAGE"

    #: A constant which can be used with the artifact_type property of a ArtifactSummary.
    #: This constant has a value of "HELM_CHART"
    ARTIFACT_TYPE_HELM_CHART = "HELM_CHART"

    #: A constant which can be used with the artifact_type property of a ArtifactSummary.
    #: This constant has a value of "MACHINE_IMAGE"
    ARTIFACT_TYPE_MACHINE_IMAGE = "MACHINE_IMAGE"

    #: A constant which can be used with the artifact_type property of a ArtifactSummary.
    #: This constant has a value of "STACK"
    ARTIFACT_TYPE_STACK = "STACK"

    def __init__(self, **kwargs):
        """
        Initializes a new ArtifactSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ArtifactSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ArtifactSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this ArtifactSummary.
        :type display_name: str

        :param artifact_type:
            The value to assign to the artifact_type property of this ArtifactSummary.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type artifact_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ArtifactSummary.
        :type lifecycle_state: str

        :param status:
            The value to assign to the status property of this ArtifactSummary.
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this ArtifactSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ArtifactSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ArtifactSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ArtifactSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ArtifactSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'artifact_type': 'str',
            'lifecycle_state': 'str',
            'status': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'artifact_type': 'artifactType',
            'lifecycle_state': 'lifecycleState',
            'status': 'status',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._artifact_type = None
        self._lifecycle_state = None
        self._status = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ArtifactSummary.
        Unique identifier for the artifact.


        :return: The id of this ArtifactSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ArtifactSummary.
        Unique identifier for the artifact.


        :param id: The id of this ArtifactSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ArtifactSummary.
        The unique identifier for the compartment.


        :return: The compartment_id of this ArtifactSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ArtifactSummary.
        The unique identifier for the compartment.


        :param compartment_id: The compartment_id of this ArtifactSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ArtifactSummary.
        The display name for the artifact.


        :return: The display_name of this ArtifactSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ArtifactSummary.
        The display name for the artifact.


        :param display_name: The display_name of this ArtifactSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def artifact_type(self):
        """
        **[Required]** Gets the artifact_type of this ArtifactSummary.
        Artifact Type for the artifact.

        Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The artifact_type of this ArtifactSummary.
        :rtype: str
        """
        return self._artifact_type

    @artifact_type.setter
    def artifact_type(self, artifact_type):
        """
        Sets the artifact_type of this ArtifactSummary.
        Artifact Type for the artifact.


        :param artifact_type: The artifact_type of this ArtifactSummary.
        :type: str
        """
        allowed_values = ["CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK"]
        if not value_allowed_none_or_none_sentinel(artifact_type, allowed_values):
            artifact_type = 'UNKNOWN_ENUM_VALUE'
        self._artifact_type = artifact_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ArtifactSummary.
        The current state for the Artifact.


        :return: The lifecycle_state of this ArtifactSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ArtifactSummary.
        The current state for the Artifact.


        :param lifecycle_state: The lifecycle_state of this ArtifactSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ArtifactSummary.
        The current status for the Artifact.


        :return: The status of this ArtifactSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ArtifactSummary.
        The current status for the Artifact.


        :param status: The status of this ArtifactSummary.
        :type: str
        """
        self._status = status

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ArtifactSummary.
        The date and time the artifact was created, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ArtifactSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ArtifactSummary.
        The date and time the artifact was created, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ArtifactSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ArtifactSummary.
        The date and time the artifact was updated, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ArtifactSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ArtifactSummary.
        The date and time the artifact was updated, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ArtifactSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ArtifactSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ArtifactSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ArtifactSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ArtifactSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ArtifactSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ArtifactSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ArtifactSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ArtifactSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ArtifactSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ArtifactSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ArtifactSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ArtifactSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
