# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DownloadInfo(object):
    """
    Guidelines to be displayed to the Customer who intends to generate a lead for a listing.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DownloadInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this DownloadInfo.
        :type description: str

        :param url:
            The value to assign to the url property of this DownloadInfo.
        :type url: str

        """
        self.swagger_types = {
            'description': 'str',
            'url': 'str'
        }
        self.attribute_map = {
            'description': 'description',
            'url': 'url'
        }
        self._description = None
        self._url = None

    @property
    def description(self):
        """
        Gets the description of this DownloadInfo.
        Text shown when capturing lead


        :return: The description of this DownloadInfo.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DownloadInfo.
        Text shown when capturing lead


        :param description: The description of this DownloadInfo.
        :type: str
        """
        self._description = description

    @property
    def url(self):
        """
        Gets the url of this DownloadInfo.
        Redirect link provided by publisher


        :return: The url of this DownloadInfo.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this DownloadInfo.
        Redirect link provided by publisher


        :param url: The url of this DownloadInfo.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
