# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .update_listing_revision_details import UpdateListingRevisionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateLeadGenListingRevisionDetails(UpdateListingRevisionDetails):
    """
    Listing revision update details for listings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateLeadGenListingRevisionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.UpdateLeadGenListingRevisionDetails.listing_type` attribute
        of this class is ``LEAD_GENERATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateLeadGenListingRevisionDetails.
        :type display_name: str

        :param headline:
            The value to assign to the headline property of this UpdateLeadGenListingRevisionDetails.
        :type headline: str

        :param listing_type:
            The value to assign to the listing_type property of this UpdateLeadGenListingRevisionDetails.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"
        :type listing_type: str

        :param tagline:
            The value to assign to the tagline property of this UpdateLeadGenListingRevisionDetails.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this UpdateLeadGenListingRevisionDetails.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this UpdateLeadGenListingRevisionDetails.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this UpdateLeadGenListingRevisionDetails.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this UpdateLeadGenListingRevisionDetails.
        :type long_description: str

        :param content_language:
            The value to assign to the content_language property of this UpdateLeadGenListingRevisionDetails.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this UpdateLeadGenListingRevisionDetails.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this UpdateLeadGenListingRevisionDetails.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this UpdateLeadGenListingRevisionDetails.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateLeadGenListingRevisionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateLeadGenListingRevisionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param version_details:
            The value to assign to the version_details property of this UpdateLeadGenListingRevisionDetails.
        :type version_details: oci.marketplace_publisher.models.VersionDetails

        :param system_requirements:
            The value to assign to the system_requirements property of this UpdateLeadGenListingRevisionDetails.
        :type system_requirements: str

        :param pricing_type:
            The value to assign to the pricing_type property of this UpdateLeadGenListingRevisionDetails.
        :type pricing_type: str

        :param products:
            The value to assign to the products property of this UpdateLeadGenListingRevisionDetails.
        :type products: list[oci.marketplace_publisher.models.ListingProduct]

        :param demo_url:
            The value to assign to the demo_url property of this UpdateLeadGenListingRevisionDetails.
        :type demo_url: str

        :param self_paced_training_url:
            The value to assign to the self_paced_training_url property of this UpdateLeadGenListingRevisionDetails.
        :type self_paced_training_url: str

        :param recommended_service_provider_listing_ids:
            The value to assign to the recommended_service_provider_listing_ids property of this UpdateLeadGenListingRevisionDetails.
        :type recommended_service_provider_listing_ids: list[str]

        :param vanity_url:
            The value to assign to the vanity_url property of this UpdateLeadGenListingRevisionDetails.
        :type vanity_url: str

        :param download_info:
            The value to assign to the download_info property of this UpdateLeadGenListingRevisionDetails.
        :type download_info: oci.marketplace_publisher.models.DownloadInfo

        :param pricing_plans:
            The value to assign to the pricing_plans property of this UpdateLeadGenListingRevisionDetails.
        :type pricing_plans: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'headline': 'str',
            'listing_type': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'version_details': 'VersionDetails',
            'system_requirements': 'str',
            'pricing_type': 'str',
            'products': 'list[ListingProduct]',
            'demo_url': 'str',
            'self_paced_training_url': 'str',
            'recommended_service_provider_listing_ids': 'list[str]',
            'vanity_url': 'str',
            'download_info': 'DownloadInfo',
            'pricing_plans': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'headline': 'headline',
            'listing_type': 'listingType',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'version_details': 'versionDetails',
            'system_requirements': 'systemRequirements',
            'pricing_type': 'pricingType',
            'products': 'products',
            'demo_url': 'demoUrl',
            'self_paced_training_url': 'selfPacedTrainingUrl',
            'recommended_service_provider_listing_ids': 'recommendedServiceProviderListingIds',
            'vanity_url': 'vanityUrl',
            'download_info': 'downloadInfo',
            'pricing_plans': 'pricingPlans'
        }
        self._display_name = None
        self._headline = None
        self._listing_type = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._freeform_tags = None
        self._defined_tags = None
        self._version_details = None
        self._system_requirements = None
        self._pricing_type = None
        self._products = None
        self._demo_url = None
        self._self_paced_training_url = None
        self._recommended_service_provider_listing_ids = None
        self._vanity_url = None
        self._download_info = None
        self._pricing_plans = None
        self._listing_type = 'LEAD_GENERATION'

    @property
    def version_details(self):
        """
        Gets the version_details of this UpdateLeadGenListingRevisionDetails.

        :return: The version_details of this UpdateLeadGenListingRevisionDetails.
        :rtype: oci.marketplace_publisher.models.VersionDetails
        """
        return self._version_details

    @version_details.setter
    def version_details(self, version_details):
        """
        Sets the version_details of this UpdateLeadGenListingRevisionDetails.

        :param version_details: The version_details of this UpdateLeadGenListingRevisionDetails.
        :type: oci.marketplace_publisher.models.VersionDetails
        """
        self._version_details = version_details

    @property
    def system_requirements(self):
        """
        Gets the system_requirements of this UpdateLeadGenListingRevisionDetails.
        System requirements for the listing revision.


        :return: The system_requirements of this UpdateLeadGenListingRevisionDetails.
        :rtype: str
        """
        return self._system_requirements

    @system_requirements.setter
    def system_requirements(self, system_requirements):
        """
        Sets the system_requirements of this UpdateLeadGenListingRevisionDetails.
        System requirements for the listing revision.


        :param system_requirements: The system_requirements of this UpdateLeadGenListingRevisionDetails.
        :type: str
        """
        self._system_requirements = system_requirements

    @property
    def pricing_type(self):
        """
        Gets the pricing_type of this UpdateLeadGenListingRevisionDetails.
        The pricing model for the listing revision.


        :return: The pricing_type of this UpdateLeadGenListingRevisionDetails.
        :rtype: str
        """
        return self._pricing_type

    @pricing_type.setter
    def pricing_type(self, pricing_type):
        """
        Sets the pricing_type of this UpdateLeadGenListingRevisionDetails.
        The pricing model for the listing revision.


        :param pricing_type: The pricing_type of this UpdateLeadGenListingRevisionDetails.
        :type: str
        """
        self._pricing_type = pricing_type

    @property
    def products(self):
        """
        Gets the products of this UpdateLeadGenListingRevisionDetails.
        List of Products subscribed by listing.


        :return: The products of this UpdateLeadGenListingRevisionDetails.
        :rtype: list[oci.marketplace_publisher.models.ListingProduct]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this UpdateLeadGenListingRevisionDetails.
        List of Products subscribed by listing.


        :param products: The products of this UpdateLeadGenListingRevisionDetails.
        :type: list[oci.marketplace_publisher.models.ListingProduct]
        """
        self._products = products

    @property
    def demo_url(self):
        """
        Gets the demo_url of this UpdateLeadGenListingRevisionDetails.
        Url to demo of the listing


        :return: The demo_url of this UpdateLeadGenListingRevisionDetails.
        :rtype: str
        """
        return self._demo_url

    @demo_url.setter
    def demo_url(self, demo_url):
        """
        Sets the demo_url of this UpdateLeadGenListingRevisionDetails.
        Url to demo of the listing


        :param demo_url: The demo_url of this UpdateLeadGenListingRevisionDetails.
        :type: str
        """
        self._demo_url = demo_url

    @property
    def self_paced_training_url(self):
        """
        Gets the self_paced_training_url of this UpdateLeadGenListingRevisionDetails.
        Url to training resources of the listing


        :return: The self_paced_training_url of this UpdateLeadGenListingRevisionDetails.
        :rtype: str
        """
        return self._self_paced_training_url

    @self_paced_training_url.setter
    def self_paced_training_url(self, self_paced_training_url):
        """
        Sets the self_paced_training_url of this UpdateLeadGenListingRevisionDetails.
        Url to training resources of the listing


        :param self_paced_training_url: The self_paced_training_url of this UpdateLeadGenListingRevisionDetails.
        :type: str
        """
        self._self_paced_training_url = self_paced_training_url

    @property
    def recommended_service_provider_listing_ids(self):
        """
        Gets the recommended_service_provider_listing_ids of this UpdateLeadGenListingRevisionDetails.
        OCIDs of service listings attached to lead gen listing


        :return: The recommended_service_provider_listing_ids of this UpdateLeadGenListingRevisionDetails.
        :rtype: list[str]
        """
        return self._recommended_service_provider_listing_ids

    @recommended_service_provider_listing_ids.setter
    def recommended_service_provider_listing_ids(self, recommended_service_provider_listing_ids):
        """
        Sets the recommended_service_provider_listing_ids of this UpdateLeadGenListingRevisionDetails.
        OCIDs of service listings attached to lead gen listing


        :param recommended_service_provider_listing_ids: The recommended_service_provider_listing_ids of this UpdateLeadGenListingRevisionDetails.
        :type: list[str]
        """
        self._recommended_service_provider_listing_ids = recommended_service_provider_listing_ids

    @property
    def vanity_url(self):
        """
        Gets the vanity_url of this UpdateLeadGenListingRevisionDetails.
        Custom link to the listing


        :return: The vanity_url of this UpdateLeadGenListingRevisionDetails.
        :rtype: str
        """
        return self._vanity_url

    @vanity_url.setter
    def vanity_url(self, vanity_url):
        """
        Sets the vanity_url of this UpdateLeadGenListingRevisionDetails.
        Custom link to the listing


        :param vanity_url: The vanity_url of this UpdateLeadGenListingRevisionDetails.
        :type: str
        """
        self._vanity_url = vanity_url

    @property
    def download_info(self):
        """
        Gets the download_info of this UpdateLeadGenListingRevisionDetails.

        :return: The download_info of this UpdateLeadGenListingRevisionDetails.
        :rtype: oci.marketplace_publisher.models.DownloadInfo
        """
        return self._download_info

    @download_info.setter
    def download_info(self, download_info):
        """
        Sets the download_info of this UpdateLeadGenListingRevisionDetails.

        :param download_info: The download_info of this UpdateLeadGenListingRevisionDetails.
        :type: oci.marketplace_publisher.models.DownloadInfo
        """
        self._download_info = download_info

    @property
    def pricing_plans(self):
        """
        Gets the pricing_plans of this UpdateLeadGenListingRevisionDetails.
        Pricing details for lead gen listing


        :return: The pricing_plans of this UpdateLeadGenListingRevisionDetails.
        :rtype: str
        """
        return self._pricing_plans

    @pricing_plans.setter
    def pricing_plans(self, pricing_plans):
        """
        Sets the pricing_plans of this UpdateLeadGenListingRevisionDetails.
        Pricing details for lead gen listing


        :param pricing_plans: The pricing_plans of this UpdateLeadGenListingRevisionDetails.
        :type: str
        """
        self._pricing_plans = pricing_plans

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
