# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MacDevice(object):
    """
    Represents a MacDevice resource.
    """

    #: A constant which can be used with the lifecycle_state property of a MacDevice.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a MacDevice.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a MacDevice.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a MacDevice.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a MacDevice.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new MacDevice object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MacDevice.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MacDevice.
        :type compartment_id: str

        :param mac_order_id:
            The value to assign to the mac_order_id property of this MacDevice.
        :type mac_order_id: str

        :param serial_number:
            The value to assign to the serial_number property of this MacDevice.
        :type serial_number: str

        :param ip_address:
            The value to assign to the ip_address property of this MacDevice.
        :type ip_address: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MacDevice.
            Allowed values for this property are: "CREATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param shape:
            The value to assign to the shape property of this MacDevice.
        :type shape: str

        :param time_created:
            The value to assign to the time_created property of this MacDevice.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this MacDevice.
        :type time_updated: datetime

        :param is_marked_decom:
            The value to assign to the is_marked_decom property of this MacDevice.
        :type is_marked_decom: bool

        :param time_decom:
            The value to assign to the time_decom property of this MacDevice.
        :type time_decom: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'mac_order_id': 'str',
            'serial_number': 'str',
            'ip_address': 'str',
            'lifecycle_state': 'str',
            'shape': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'is_marked_decom': 'bool',
            'time_decom': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'mac_order_id': 'macOrderId',
            'serial_number': 'serialNumber',
            'ip_address': 'ipAddress',
            'lifecycle_state': 'lifecycleState',
            'shape': 'shape',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'is_marked_decom': 'isMarkedDecom',
            'time_decom': 'timeDecom'
        }
        self._id = None
        self._compartment_id = None
        self._mac_order_id = None
        self._serial_number = None
        self._ip_address = None
        self._lifecycle_state = None
        self._shape = None
        self._time_created = None
        self._time_updated = None
        self._is_marked_decom = None
        self._time_decom = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MacDevice.
        The unique ID of the MacDevice.


        :return: The id of this MacDevice.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MacDevice.
        The unique ID of the MacDevice.


        :param id: The id of this MacDevice.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this MacDevice.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this MacDevice.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this MacDevice.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this MacDevice.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def mac_order_id(self):
        """
        **[Required]** Gets the mac_order_id of this MacDevice.
        The OCID of the resource.


        :return: The mac_order_id of this MacDevice.
        :rtype: str
        """
        return self._mac_order_id

    @mac_order_id.setter
    def mac_order_id(self, mac_order_id):
        """
        Sets the mac_order_id of this MacDevice.
        The OCID of the resource.


        :param mac_order_id: The mac_order_id of this MacDevice.
        :type: str
        """
        self._mac_order_id = mac_order_id

    @property
    def serial_number(self):
        """
        **[Required]** Gets the serial_number of this MacDevice.
        The serial number of the MacDevice.


        :return: The serial_number of this MacDevice.
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """
        Sets the serial_number of this MacDevice.
        The serial number of the MacDevice.


        :param serial_number: The serial_number of this MacDevice.
        :type: str
        """
        self._serial_number = serial_number

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this MacDevice.
        The IP address assigned to the MacDevice.


        :return: The ip_address of this MacDevice.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this MacDevice.
        The IP address assigned to the MacDevice.


        :param ip_address: The ip_address of this MacDevice.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this MacDevice.
        The current status of the MacDevice.

        Allowed values for this property are: "CREATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this MacDevice.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MacDevice.
        The current status of the MacDevice.


        :param lifecycle_state: The lifecycle_state of this MacDevice.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this MacDevice.
        The shape of the Mac.


        :return: The shape of this MacDevice.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this MacDevice.
        The shape of the Mac.


        :param shape: The shape of this MacDevice.
        :type: str
        """
        self._shape = shape

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MacDevice.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this MacDevice.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MacDevice.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this MacDevice.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this MacDevice.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this MacDevice.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this MacDevice.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this MacDevice.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def is_marked_decom(self):
        """
        **[Required]** Gets the is_marked_decom of this MacDevice.
        A flag that indicates if this MacDevice is decommissioned.


        :return: The is_marked_decom of this MacDevice.
        :rtype: bool
        """
        return self._is_marked_decom

    @is_marked_decom.setter
    def is_marked_decom(self, is_marked_decom):
        """
        Sets the is_marked_decom of this MacDevice.
        A flag that indicates if this MacDevice is decommissioned.


        :param is_marked_decom: The is_marked_decom of this MacDevice.
        :type: bool
        """
        self._is_marked_decom = is_marked_decom

    @property
    def time_decom(self):
        """
        **[Required]** Gets the time_decom of this MacDevice.
        An RFC3339-formatted datetime string containing the time this MacDevice was decommissioned.


        :return: The time_decom of this MacDevice.
        :rtype: datetime
        """
        return self._time_decom

    @time_decom.setter
    def time_decom(self, time_decom):
        """
        Sets the time_decom of this MacDevice.
        An RFC3339-formatted datetime string containing the time this MacDevice was decommissioned.


        :param time_decom: The time_decom of this MacDevice.
        :type: datetime
        """
        self._time_decom = time_decom

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
