# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpsActionUpdateMacOrderDetails(object):
    """
    The data to update an order in MAC_ORDER bucket.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OpsActionUpdateMacOrderDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param order_status:
            The value to assign to the order_status property of this OpsActionUpdateMacOrderDetails.
        :type order_status: str

        :param ip_range:
            The value to assign to the ip_range property of this OpsActionUpdateMacOrderDetails.
        :type ip_range: str

        :param time_billing_started:
            The value to assign to the time_billing_started property of this OpsActionUpdateMacOrderDetails.
        :type time_billing_started: datetime

        :param time_billing_ended:
            The value to assign to the time_billing_ended property of this OpsActionUpdateMacOrderDetails.
        :type time_billing_ended: datetime

        """
        self.swagger_types = {
            'order_status': 'str',
            'ip_range': 'str',
            'time_billing_started': 'datetime',
            'time_billing_ended': 'datetime'
        }
        self.attribute_map = {
            'order_status': 'orderStatus',
            'ip_range': 'ipRange',
            'time_billing_started': 'timeBillingStarted',
            'time_billing_ended': 'timeBillingEnded'
        }
        self._order_status = None
        self._ip_range = None
        self._time_billing_started = None
        self._time_billing_ended = None

    @property
    def order_status(self):
        """
        Gets the order_status of this OpsActionUpdateMacOrderDetails.
        The new status of the MacOrder.


        :return: The order_status of this OpsActionUpdateMacOrderDetails.
        :rtype: str
        """
        return self._order_status

    @order_status.setter
    def order_status(self, order_status):
        """
        Sets the order_status of this OpsActionUpdateMacOrderDetails.
        The new status of the MacOrder.


        :param order_status: The order_status of this OpsActionUpdateMacOrderDetails.
        :type: str
        """
        self._order_status = order_status

    @property
    def ip_range(self):
        """
        Gets the ip_range of this OpsActionUpdateMacOrderDetails.
        The IP Range specified by the customer for this order.


        :return: The ip_range of this OpsActionUpdateMacOrderDetails.
        :rtype: str
        """
        return self._ip_range

    @ip_range.setter
    def ip_range(self, ip_range):
        """
        Sets the ip_range of this OpsActionUpdateMacOrderDetails.
        The IP Range specified by the customer for this order.


        :param ip_range: The ip_range of this OpsActionUpdateMacOrderDetails.
        :type: str
        """
        self._ip_range = ip_range

    @property
    def time_billing_started(self):
        """
        Gets the time_billing_started of this OpsActionUpdateMacOrderDetails.
        The date and time this mac order is Active from. An RFC3339 formatted datetime string.


        :return: The time_billing_started of this OpsActionUpdateMacOrderDetails.
        :rtype: datetime
        """
        return self._time_billing_started

    @time_billing_started.setter
    def time_billing_started(self, time_billing_started):
        """
        Sets the time_billing_started of this OpsActionUpdateMacOrderDetails.
        The date and time this mac order is Active from. An RFC3339 formatted datetime string.


        :param time_billing_started: The time_billing_started of this OpsActionUpdateMacOrderDetails.
        :type: datetime
        """
        self._time_billing_started = time_billing_started

    @property
    def time_billing_ended(self):
        """
        Gets the time_billing_ended of this OpsActionUpdateMacOrderDetails.
        The date and time this mac order until which this mac is Active. An RFC3339 formatted datetime string.


        :return: The time_billing_ended of this OpsActionUpdateMacOrderDetails.
        :rtype: datetime
        """
        return self._time_billing_ended

    @time_billing_ended.setter
    def time_billing_ended(self, time_billing_ended):
        """
        Sets the time_billing_ended of this OpsActionUpdateMacOrderDetails.
        The date and time this mac order until which this mac is Active. An RFC3339 formatted datetime string.


        :param time_billing_ended: The time_billing_ended of this OpsActionUpdateMacOrderDetails.
        :type: datetime
        """
        self._time_billing_ended = time_billing_ended

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
