# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMacOrderDetails(object):
    """
    The data to update a MacOrder.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMacOrderDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateMacOrderDetails.
        :type display_name: str

        :param order_description:
            The value to assign to the order_description property of this UpdateMacOrderDetails.
        :type order_description: str

        :param order_size:
            The value to assign to the order_size property of this UpdateMacOrderDetails.
        :type order_size: int

        :param shape:
            The value to assign to the shape property of this UpdateMacOrderDetails.
        :type shape: str

        :param ip_range:
            The value to assign to the ip_range property of this UpdateMacOrderDetails.
        :type ip_range: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'order_description': 'str',
            'order_size': 'int',
            'shape': 'str',
            'ip_range': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'order_description': 'orderDescription',
            'order_size': 'orderSize',
            'shape': 'shape',
            'ip_range': 'ipRange'
        }
        self._display_name = None
        self._order_description = None
        self._order_size = None
        self._shape = None
        self._ip_range = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateMacOrderDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this UpdateMacOrderDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateMacOrderDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this UpdateMacOrderDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def order_description(self):
        """
        Gets the order_description of this UpdateMacOrderDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The order_description of this UpdateMacOrderDetails.
        :rtype: str
        """
        return self._order_description

    @order_description.setter
    def order_description(self, order_description):
        """
        Sets the order_description of this UpdateMacOrderDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param order_description: The order_description of this UpdateMacOrderDetails.
        :type: str
        """
        self._order_description = order_description

    @property
    def order_size(self):
        """
        Gets the order_size of this UpdateMacOrderDetails.
        Number of macs requested in this MacOrder.


        :return: The order_size of this UpdateMacOrderDetails.
        :rtype: int
        """
        return self._order_size

    @order_size.setter
    def order_size(self, order_size):
        """
        Sets the order_size of this UpdateMacOrderDetails.
        Number of macs requested in this MacOrder.


        :param order_size: The order_size of this UpdateMacOrderDetails.
        :type: int
        """
        self._order_size = order_size

    @property
    def shape(self):
        """
        Gets the shape of this UpdateMacOrderDetails.
        The shape of the Mac.


        :return: The shape of this UpdateMacOrderDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this UpdateMacOrderDetails.
        The shape of the Mac.


        :param shape: The shape of this UpdateMacOrderDetails.
        :type: str
        """
        self._shape = shape

    @property
    def ip_range(self):
        """
        Gets the ip_range of this UpdateMacOrderDetails.
        The IP Range specified by the customer for this order.


        :return: The ip_range of this UpdateMacOrderDetails.
        :rtype: str
        """
        return self._ip_range

    @ip_range.setter
    def ip_range(self, ip_range):
        """
        Sets the ip_range of this UpdateMacOrderDetails.
        The IP Range specified by the customer for this order.


        :param ip_range: The ip_range of this UpdateMacOrderDetails.
        :type: str
        """
        self._ip_range = ip_range

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
