# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciDns(object):
    """
    Oracle Cloud Infrastructure network anchor related meta data items
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciDns object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param custom_domain_name:
            The value to assign to the custom_domain_name property of this OciDns.
        :type custom_domain_name: str

        """
        self.swagger_types = {
            'custom_domain_name': 'str'
        }
        self.attribute_map = {
            'custom_domain_name': 'customDomainName'
        }
        self._custom_domain_name = None

    @property
    def custom_domain_name(self):
        """
        Gets the custom_domain_name of this OciDns.
        Full custom domain name. If this field is passed dnsLabel will be ignored


        :return: The custom_domain_name of this OciDns.
        :rtype: str
        """
        return self._custom_domain_name

    @custom_domain_name.setter
    def custom_domain_name(self, custom_domain_name):
        """
        Sets the custom_domain_name of this OciDns.
        Full custom domain name. If this field is passed dnsLabel will be ignored


        :param custom_domain_name: The custom_domain_name of this OciDns.
        :type: str
        """
        self._custom_domain_name = custom_domain_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
