# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChannelStatus(object):
    """
    Runtime status summary of a Channel, aggregating information about health and operational indicators.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChannelStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_created:
            The value to assign to the time_created property of this ChannelStatus.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ChannelStatus.
        :type time_updated: datetime

        :param channel_status_result:
            The value to assign to the channel_status_result property of this ChannelStatus.
        :type channel_status_result: oci.mysql.models.ChannelStatusResult

        """
        self.swagger_types = {
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'channel_status_result': 'ChannelStatusResult'
        }
        self.attribute_map = {
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'channel_status_result': 'channelStatusResult'
        }
        self._time_created = None
        self._time_updated = None
        self._channel_status_result = None

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ChannelStatus.
        The date and time that the Work Request to generate the Channel status was issued,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this ChannelStatus.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ChannelStatus.
        The date and time that the Work Request to generate the Channel status was issued,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this ChannelStatus.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ChannelStatus.
        The date and time that the Channel status was generated,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this ChannelStatus.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ChannelStatus.
        The date and time that the Channel status was generated,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this ChannelStatus.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def channel_status_result(self):
        """
        **[Required]** Gets the channel_status_result of this ChannelStatus.

        :return: The channel_status_result of this ChannelStatus.
        :rtype: oci.mysql.models.ChannelStatusResult
        """
        return self._channel_status_result

    @channel_status_result.setter
    def channel_status_result(self, channel_status_result):
        """
        Sets the channel_status_result of this ChannelStatus.

        :param channel_status_result: The channel_status_result of this ChannelStatus.
        :type: oci.mysql.models.ChannelStatusResult
        """
        self._channel_status_result = channel_status_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
