# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChannelStatusResult(object):
    """
    Status information for the channel attached to the DB System.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChannelStatusResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param channel_id:
            The value to assign to the channel_id property of this ChannelStatusResult.
        :type channel_id: str

        :param is_healthy:
            The value to assign to the is_healthy property of this ChannelStatusResult.
        :type is_healthy: bool

        :param is_received_gtid_set_applied:
            The value to assign to the is_received_gtid_set_applied property of this ChannelStatusResult.
        :type is_received_gtid_set_applied: bool

        :param errors:
            The value to assign to the errors property of this ChannelStatusResult.
        :type errors: list[str]

        :param lag_duration:
            The value to assign to the lag_duration property of this ChannelStatusResult.
        :type lag_duration: str

        """
        self.swagger_types = {
            'channel_id': 'str',
            'is_healthy': 'bool',
            'is_received_gtid_set_applied': 'bool',
            'errors': 'list[str]',
            'lag_duration': 'str'
        }
        self.attribute_map = {
            'channel_id': 'channelId',
            'is_healthy': 'isHealthy',
            'is_received_gtid_set_applied': 'isReceivedGtidSetApplied',
            'errors': 'errors',
            'lag_duration': 'lagDuration'
        }
        self._channel_id = None
        self._is_healthy = None
        self._is_received_gtid_set_applied = None
        self._errors = None
        self._lag_duration = None

    @property
    def channel_id(self):
        """
        **[Required]** Gets the channel_id of this ChannelStatusResult.
        The OCID of the Channel for which the status is gathered.


        :return: The channel_id of this ChannelStatusResult.
        :rtype: str
        """
        return self._channel_id

    @channel_id.setter
    def channel_id(self, channel_id):
        """
        Sets the channel_id of this ChannelStatusResult.
        The OCID of the Channel for which the status is gathered.


        :param channel_id: The channel_id of this ChannelStatusResult.
        :type: str
        """
        self._channel_id = channel_id

    @property
    def is_healthy(self):
        """
        Gets the is_healthy of this ChannelStatusResult.
        Specifies if the channel is healthy or not. If healthy, replication target DB System is connected to the
        source and no replication errors are seen.


        :return: The is_healthy of this ChannelStatusResult.
        :rtype: bool
        """
        return self._is_healthy

    @is_healthy.setter
    def is_healthy(self, is_healthy):
        """
        Sets the is_healthy of this ChannelStatusResult.
        Specifies if the channel is healthy or not. If healthy, replication target DB System is connected to the
        source and no replication errors are seen.


        :param is_healthy: The is_healthy of this ChannelStatusResult.
        :type: bool
        """
        self._is_healthy = is_healthy

    @property
    def is_received_gtid_set_applied(self):
        """
        Gets the is_received_gtid_set_applied of this ChannelStatusResult.
        Specifies if all transactions received by this channel are executed and their GTIDs are part of gtid_executed
        set.


        :return: The is_received_gtid_set_applied of this ChannelStatusResult.
        :rtype: bool
        """
        return self._is_received_gtid_set_applied

    @is_received_gtid_set_applied.setter
    def is_received_gtid_set_applied(self, is_received_gtid_set_applied):
        """
        Sets the is_received_gtid_set_applied of this ChannelStatusResult.
        Specifies if all transactions received by this channel are executed and their GTIDs are part of gtid_executed
        set.


        :param is_received_gtid_set_applied: The is_received_gtid_set_applied of this ChannelStatusResult.
        :type: bool
        """
        self._is_received_gtid_set_applied = is_received_gtid_set_applied

    @property
    def errors(self):
        """
        Gets the errors of this ChannelStatusResult.
        Channel errors identified, if there are any.


        :return: The errors of this ChannelStatusResult.
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this ChannelStatusResult.
        Channel errors identified, if there are any.


        :param errors: The errors of this ChannelStatusResult.
        :type: list[str]
        """
        self._errors = errors

    @property
    def lag_duration(self):
        """
        Gets the lag_duration of this ChannelStatusResult.
        The channel lag, with respect to the immediate source of the channel.
        If the channel is configured with replication delay, the channel lag includes the replication delay.


        :return: The lag_duration of this ChannelStatusResult.
        :rtype: str
        """
        return self._lag_duration

    @lag_duration.setter
    def lag_duration(self, lag_duration):
        """
        Sets the lag_duration of this ChannelStatusResult.
        The channel lag, with respect to the immediate source of the channel.
        If the channel is configured with replication delay, the channel lag includes the replication delay.


        :param lag_duration: The lag_duration of this ChannelStatusResult.
        :type: str
        """
        self._lag_duration = lag_duration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
