# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystem(object):
    """
    A DB System is the core logical unit of MySQL Database Service.
    """

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the crash_recovery property of a DbSystem.
    #: This constant has a value of "ENABLED"
    CRASH_RECOVERY_ENABLED = "ENABLED"

    #: A constant which can be used with the crash_recovery property of a DbSystem.
    #: This constant has a value of "DISABLED"
    CRASH_RECOVERY_DISABLED = "DISABLED"

    #: A constant which can be used with the database_management property of a DbSystem.
    #: This constant has a value of "ENABLED"
    DATABASE_MANAGEMENT_ENABLED = "ENABLED"

    #: A constant which can be used with the database_management property of a DbSystem.
    #: This constant has a value of "DISABLED"
    DATABASE_MANAGEMENT_DISABLED = "DISABLED"

    #: A constant which can be used with the database_mode property of a DbSystem.
    #: This constant has a value of "READ_WRITE"
    DATABASE_MODE_READ_WRITE = "READ_WRITE"

    #: A constant which can be used with the database_mode property of a DbSystem.
    #: This constant has a value of "READ_ONLY"
    DATABASE_MODE_READ_ONLY = "READ_ONLY"

    #: A constant which can be used with the access_mode property of a DbSystem.
    #: This constant has a value of "UNRESTRICTED"
    ACCESS_MODE_UNRESTRICTED = "UNRESTRICTED"

    #: A constant which can be used with the access_mode property of a DbSystem.
    #: This constant has a value of "RESTRICTED"
    ACCESS_MODE_RESTRICTED = "RESTRICTED"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbSystem.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DbSystem.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DbSystem.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DbSystem.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this DbSystem.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this DbSystem.
        :type nsg_ids: list[str]

        :param security_attributes:
            The value to assign to the security_attributes property of this DbSystem.
        :type security_attributes: dict(str, dict(str, object))

        :param rest:
            The value to assign to the rest property of this DbSystem.
        :type rest: oci.mysql.models.RestDetails

        :param database_console:
            The value to assign to the database_console property of this DbSystem.
        :type database_console: oci.mysql.models.DatabaseConsoleDetails

        :param is_highly_available:
            The value to assign to the is_highly_available property of this DbSystem.
        :type is_highly_available: bool

        :param current_placement:
            The value to assign to the current_placement property of this DbSystem.
        :type current_placement: oci.mysql.models.DbSystemPlacement

        :param is_heat_wave_cluster_attached:
            The value to assign to the is_heat_wave_cluster_attached property of this DbSystem.
        :type is_heat_wave_cluster_attached: bool

        :param heat_wave_cluster:
            The value to assign to the heat_wave_cluster property of this DbSystem.
        :type heat_wave_cluster: oci.mysql.models.HeatWaveClusterSummary

        :param availability_domain:
            The value to assign to the availability_domain property of this DbSystem.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this DbSystem.
        :type fault_domain: str

        :param shape_name:
            The value to assign to the shape_name property of this DbSystem.
        :type shape_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this DbSystem.
        :type mysql_version: str

        :param backup_policy:
            The value to assign to the backup_policy property of this DbSystem.
        :type backup_policy: oci.mysql.models.BackupPolicy

        :param source:
            The value to assign to the source property of this DbSystem.
        :type source: oci.mysql.models.DbSystemSource

        :param configuration_id:
            The value to assign to the configuration_id property of this DbSystem.
        :type configuration_id: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this DbSystem.
        :type data_storage_size_in_gbs: int

        :param data_storage:
            The value to assign to the data_storage property of this DbSystem.
        :type data_storage: oci.mysql.models.DataStorage

        :param hostname_label:
            The value to assign to the hostname_label property of this DbSystem.
        :type hostname_label: str

        :param ip_address:
            The value to assign to the ip_address property of this DbSystem.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this DbSystem.
        :type port: int

        :param port_x:
            The value to assign to the port_x property of this DbSystem.
        :type port_x: int

        :param endpoints:
            The value to assign to the endpoints property of this DbSystem.
        :type endpoints: list[oci.mysql.models.DbSystemEndpoint]

        :param channels:
            The value to assign to the channels property of this DbSystem.
        :type channels: list[oci.mysql.models.ChannelSummary]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbSystem.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DbSystem.
        :type lifecycle_details: str

        :param maintenance:
            The value to assign to the maintenance property of this DbSystem.
        :type maintenance: oci.mysql.models.MaintenanceDetails

        :param deletion_policy:
            The value to assign to the deletion_policy property of this DbSystem.
        :type deletion_policy: oci.mysql.models.DeletionPolicyDetails

        :param time_created:
            The value to assign to the time_created property of this DbSystem.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DbSystem.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbSystem.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbSystem.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DbSystem.
        :type system_tags: dict(str, dict(str, object))

        :param crash_recovery:
            The value to assign to the crash_recovery property of this DbSystem.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type crash_recovery: str

        :param point_in_time_recovery_details:
            The value to assign to the point_in_time_recovery_details property of this DbSystem.
        :type point_in_time_recovery_details: oci.mysql.models.PointInTimeRecoveryDetails

        :param database_management:
            The value to assign to the database_management property of this DbSystem.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_management: str

        :param secure_connections:
            The value to assign to the secure_connections property of this DbSystem.
        :type secure_connections: oci.mysql.models.SecureConnectionDetails

        :param encrypt_data:
            The value to assign to the encrypt_data property of this DbSystem.
        :type encrypt_data: oci.mysql.models.EncryptDataDetails

        :param database_mode:
            The value to assign to the database_mode property of this DbSystem.
            Allowed values for this property are: "READ_WRITE", "READ_ONLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_mode: str

        :param access_mode:
            The value to assign to the access_mode property of this DbSystem.
            Allowed values for this property are: "UNRESTRICTED", "RESTRICTED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type access_mode: str

        :param customer_contacts:
            The value to assign to the customer_contacts property of this DbSystem.
        :type customer_contacts: list[oci.mysql.models.CustomerContact]

        :param read_endpoint:
            The value to assign to the read_endpoint property of this DbSystem.
        :type read_endpoint: oci.mysql.models.ReadEndpointDetails

        :param telemetry_configuration:
            The value to assign to the telemetry_configuration property of this DbSystem.
        :type telemetry_configuration: oci.mysql.models.TelemetryConfigurationDetails

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'security_attributes': 'dict(str, dict(str, object))',
            'rest': 'RestDetails',
            'database_console': 'DatabaseConsoleDetails',
            'is_highly_available': 'bool',
            'current_placement': 'DbSystemPlacement',
            'is_heat_wave_cluster_attached': 'bool',
            'heat_wave_cluster': 'HeatWaveClusterSummary',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'shape_name': 'str',
            'mysql_version': 'str',
            'backup_policy': 'BackupPolicy',
            'source': 'DbSystemSource',
            'configuration_id': 'str',
            'data_storage_size_in_gbs': 'int',
            'data_storage': 'DataStorage',
            'hostname_label': 'str',
            'ip_address': 'str',
            'port': 'int',
            'port_x': 'int',
            'endpoints': 'list[DbSystemEndpoint]',
            'channels': 'list[ChannelSummary]',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'maintenance': 'MaintenanceDetails',
            'deletion_policy': 'DeletionPolicyDetails',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'crash_recovery': 'str',
            'point_in_time_recovery_details': 'PointInTimeRecoveryDetails',
            'database_management': 'str',
            'secure_connections': 'SecureConnectionDetails',
            'encrypt_data': 'EncryptDataDetails',
            'database_mode': 'str',
            'access_mode': 'str',
            'customer_contacts': 'list[CustomerContact]',
            'read_endpoint': 'ReadEndpointDetails',
            'telemetry_configuration': 'TelemetryConfigurationDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'security_attributes': 'securityAttributes',
            'rest': 'rest',
            'database_console': 'databaseConsole',
            'is_highly_available': 'isHighlyAvailable',
            'current_placement': 'currentPlacement',
            'is_heat_wave_cluster_attached': 'isHeatWaveClusterAttached',
            'heat_wave_cluster': 'heatWaveCluster',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'shape_name': 'shapeName',
            'mysql_version': 'mysqlVersion',
            'backup_policy': 'backupPolicy',
            'source': 'source',
            'configuration_id': 'configurationId',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'data_storage': 'dataStorage',
            'hostname_label': 'hostnameLabel',
            'ip_address': 'ipAddress',
            'port': 'port',
            'port_x': 'portX',
            'endpoints': 'endpoints',
            'channels': 'channels',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'maintenance': 'maintenance',
            'deletion_policy': 'deletionPolicy',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'crash_recovery': 'crashRecovery',
            'point_in_time_recovery_details': 'pointInTimeRecoveryDetails',
            'database_management': 'databaseManagement',
            'secure_connections': 'secureConnections',
            'encrypt_data': 'encryptData',
            'database_mode': 'databaseMode',
            'access_mode': 'accessMode',
            'customer_contacts': 'customerContacts',
            'read_endpoint': 'readEndpoint',
            'telemetry_configuration': 'telemetryConfiguration'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._subnet_id = None
        self._nsg_ids = None
        self._security_attributes = None
        self._rest = None
        self._database_console = None
        self._is_highly_available = None
        self._current_placement = None
        self._is_heat_wave_cluster_attached = None
        self._heat_wave_cluster = None
        self._availability_domain = None
        self._fault_domain = None
        self._shape_name = None
        self._mysql_version = None
        self._backup_policy = None
        self._source = None
        self._configuration_id = None
        self._data_storage_size_in_gbs = None
        self._data_storage = None
        self._hostname_label = None
        self._ip_address = None
        self._port = None
        self._port_x = None
        self._endpoints = None
        self._channels = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._maintenance = None
        self._deletion_policy = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._crash_recovery = None
        self._point_in_time_recovery_details = None
        self._database_management = None
        self._secure_connections = None
        self._encrypt_data = None
        self._database_mode = None
        self._access_mode = None
        self._customer_contacts = None
        self._read_endpoint = None
        self._telemetry_configuration = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbSystem.
        The OCID of the DB System.


        :return: The id of this DbSystem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbSystem.
        The OCID of the DB System.


        :param id: The id of this DbSystem.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DbSystem.
        The user-friendly name for the DB System. It does not have to be unique.


        :return: The display_name of this DbSystem.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DbSystem.
        The user-friendly name for the DB System. It does not have to be unique.


        :param display_name: The display_name of this DbSystem.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DbSystem.
        User-provided data about the DB System.


        :return: The description of this DbSystem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DbSystem.
        User-provided data about the DB System.


        :param description: The description of this DbSystem.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DbSystem.
        The OCID of the compartment the DB System belongs in.


        :return: The compartment_id of this DbSystem.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbSystem.
        The OCID of the compartment the DB System belongs in.


        :param compartment_id: The compartment_id of this DbSystem.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this DbSystem.
        The OCID of the subnet the DB System is associated with.


        :return: The subnet_id of this DbSystem.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this DbSystem.
        The OCID of the subnet the DB System is associated with.


        :param subnet_id: The subnet_id of this DbSystem.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this DbSystem.
        Network Security Group OCIDs used for the VNIC attachment.


        :return: The nsg_ids of this DbSystem.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this DbSystem.
        Network Security Group OCIDs used for the VNIC attachment.


        :param nsg_ids: The nsg_ids of this DbSystem.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this DbSystem.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `ZPR Artifacts`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm


        :return: The security_attributes of this DbSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this DbSystem.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `ZPR Artifacts`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm


        :param security_attributes: The security_attributes of this DbSystem.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def rest(self):
        """
        Gets the rest of this DbSystem.

        :return: The rest of this DbSystem.
        :rtype: oci.mysql.models.RestDetails
        """
        return self._rest

    @rest.setter
    def rest(self, rest):
        """
        Sets the rest of this DbSystem.

        :param rest: The rest of this DbSystem.
        :type: oci.mysql.models.RestDetails
        """
        self._rest = rest

    @property
    def database_console(self):
        """
        Gets the database_console of this DbSystem.

        :return: The database_console of this DbSystem.
        :rtype: oci.mysql.models.DatabaseConsoleDetails
        """
        return self._database_console

    @database_console.setter
    def database_console(self, database_console):
        """
        Sets the database_console of this DbSystem.

        :param database_console: The database_console of this DbSystem.
        :type: oci.mysql.models.DatabaseConsoleDetails
        """
        self._database_console = database_console

    @property
    def is_highly_available(self):
        """
        Gets the is_highly_available of this DbSystem.
        Specifies if the DB System is highly available.


        :return: The is_highly_available of this DbSystem.
        :rtype: bool
        """
        return self._is_highly_available

    @is_highly_available.setter
    def is_highly_available(self, is_highly_available):
        """
        Sets the is_highly_available of this DbSystem.
        Specifies if the DB System is highly available.


        :param is_highly_available: The is_highly_available of this DbSystem.
        :type: bool
        """
        self._is_highly_available = is_highly_available

    @property
    def current_placement(self):
        """
        Gets the current_placement of this DbSystem.

        :return: The current_placement of this DbSystem.
        :rtype: oci.mysql.models.DbSystemPlacement
        """
        return self._current_placement

    @current_placement.setter
    def current_placement(self, current_placement):
        """
        Sets the current_placement of this DbSystem.

        :param current_placement: The current_placement of this DbSystem.
        :type: oci.mysql.models.DbSystemPlacement
        """
        self._current_placement = current_placement

    @property
    def is_heat_wave_cluster_attached(self):
        """
        Gets the is_heat_wave_cluster_attached of this DbSystem.
        If the DB System has a HeatWave Cluster attached.


        :return: The is_heat_wave_cluster_attached of this DbSystem.
        :rtype: bool
        """
        return self._is_heat_wave_cluster_attached

    @is_heat_wave_cluster_attached.setter
    def is_heat_wave_cluster_attached(self, is_heat_wave_cluster_attached):
        """
        Sets the is_heat_wave_cluster_attached of this DbSystem.
        If the DB System has a HeatWave Cluster attached.


        :param is_heat_wave_cluster_attached: The is_heat_wave_cluster_attached of this DbSystem.
        :type: bool
        """
        self._is_heat_wave_cluster_attached = is_heat_wave_cluster_attached

    @property
    def heat_wave_cluster(self):
        """
        Gets the heat_wave_cluster of this DbSystem.

        :return: The heat_wave_cluster of this DbSystem.
        :rtype: oci.mysql.models.HeatWaveClusterSummary
        """
        return self._heat_wave_cluster

    @heat_wave_cluster.setter
    def heat_wave_cluster(self, heat_wave_cluster):
        """
        Sets the heat_wave_cluster of this DbSystem.

        :param heat_wave_cluster: The heat_wave_cluster of this DbSystem.
        :type: oci.mysql.models.HeatWaveClusterSummary
        """
        self._heat_wave_cluster = heat_wave_cluster

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this DbSystem.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :return: The availability_domain of this DbSystem.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this DbSystem.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :param availability_domain: The availability_domain of this DbSystem.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this DbSystem.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :return: The fault_domain of this DbSystem.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this DbSystem.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :param fault_domain: The fault_domain of this DbSystem.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def shape_name(self):
        """
        Gets the shape_name of this DbSystem.
        The shape of the primary instances of the DB System. The shape
        determines resources allocated to a DB System - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM
        (or bare metal) shapes. To get a list of shapes, use (the
        :func:`list_shapes` operation.


        :return: The shape_name of this DbSystem.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this DbSystem.
        The shape of the primary instances of the DB System. The shape
        determines resources allocated to a DB System - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM
        (or bare metal) shapes. To get a list of shapes, use (the
        :func:`list_shapes` operation.


        :param shape_name: The shape_name of this DbSystem.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def mysql_version(self):
        """
        **[Required]** Gets the mysql_version of this DbSystem.
        Name of the MySQL Version in use for the DB System.


        :return: The mysql_version of this DbSystem.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this DbSystem.
        Name of the MySQL Version in use for the DB System.


        :param mysql_version: The mysql_version of this DbSystem.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this DbSystem.

        :return: The backup_policy of this DbSystem.
        :rtype: oci.mysql.models.BackupPolicy
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this DbSystem.

        :param backup_policy: The backup_policy of this DbSystem.
        :type: oci.mysql.models.BackupPolicy
        """
        self._backup_policy = backup_policy

    @property
    def source(self):
        """
        Gets the source of this DbSystem.

        :return: The source of this DbSystem.
        :rtype: oci.mysql.models.DbSystemSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this DbSystem.

        :param source: The source of this DbSystem.
        :type: oci.mysql.models.DbSystemSource
        """
        self._source = source

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this DbSystem.
        The OCID of the Configuration to be used for Instances in this DB System.


        :return: The configuration_id of this DbSystem.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this DbSystem.
        The OCID of the Configuration to be used for Instances in this DB System.


        :param configuration_id: The configuration_id of this DbSystem.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this DbSystem.
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs.
        Replaced by dataStorage.dataStorageSizeInGBs.


        :return: The data_storage_size_in_gbs of this DbSystem.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this DbSystem.
        DEPRECATED: User specified size of the data volume. May be less than current allocatedStorageSizeInGBs.
        Replaced by dataStorage.dataStorageSizeInGBs.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this DbSystem.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def data_storage(self):
        """
        **[Required]** Gets the data_storage of this DbSystem.

        :return: The data_storage of this DbSystem.
        :rtype: oci.mysql.models.DataStorage
        """
        return self._data_storage

    @data_storage.setter
    def data_storage(self, data_storage):
        """
        Sets the data_storage of this DbSystem.

        :param data_storage: The data_storage of this DbSystem.
        :type: oci.mysql.models.DataStorage
        """
        self._data_storage = data_storage

    @property
    def hostname_label(self):
        """
        Gets the hostname_label of this DbSystem.
        The hostname for the primary endpoint of the DB System. Used for DNS.
        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)
        (for example, \"dbsystem-1\" in FQDN \"dbsystem-1.subnet123.vcn1.oraclevcn.com\").
        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.


        :return: The hostname_label of this DbSystem.
        :rtype: str
        """
        return self._hostname_label

    @hostname_label.setter
    def hostname_label(self, hostname_label):
        """
        Sets the hostname_label of this DbSystem.
        The hostname for the primary endpoint of the DB System. Used for DNS.
        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)
        (for example, \"dbsystem-1\" in FQDN \"dbsystem-1.subnet123.vcn1.oraclevcn.com\").
        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.


        :param hostname_label: The hostname_label of this DbSystem.
        :type: str
        """
        self._hostname_label = hostname_label

    @property
    def ip_address(self):
        """
        Gets the ip_address of this DbSystem.
        The IP address the DB System is configured to listen on. A private
        IP address of the primary endpoint of the DB System. Must be an
        available IP address within the subnet's CIDR. This will be a
        \"dotted-quad\" style IPv4 address.


        :return: The ip_address of this DbSystem.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this DbSystem.
        The IP address the DB System is configured to listen on. A private
        IP address of the primary endpoint of the DB System. Must be an
        available IP address within the subnet's CIDR. This will be a
        \"dotted-quad\" style IPv4 address.


        :param ip_address: The ip_address of this DbSystem.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        Gets the port of this DbSystem.
        The port for primary endpoint of the DB System to listen on.


        :return: The port of this DbSystem.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this DbSystem.
        The port for primary endpoint of the DB System to listen on.


        :param port: The port of this DbSystem.
        :type: int
        """
        self._port = port

    @property
    def port_x(self):
        """
        Gets the port_x of this DbSystem.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :return: The port_x of this DbSystem.
        :rtype: int
        """
        return self._port_x

    @port_x.setter
    def port_x(self, port_x):
        """
        Sets the port_x of this DbSystem.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :param port_x: The port_x of this DbSystem.
        :type: int
        """
        self._port_x = port_x

    @property
    def endpoints(self):
        """
        Gets the endpoints of this DbSystem.
        The network endpoints available for this DB System.


        :return: The endpoints of this DbSystem.
        :rtype: list[oci.mysql.models.DbSystemEndpoint]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """
        Sets the endpoints of this DbSystem.
        The network endpoints available for this DB System.


        :param endpoints: The endpoints of this DbSystem.
        :type: list[oci.mysql.models.DbSystemEndpoint]
        """
        self._endpoints = endpoints

    @property
    def channels(self):
        """
        Gets the channels of this DbSystem.
        A list with a summary of all the Channels attached to the DB System.


        :return: The channels of this DbSystem.
        :rtype: list[oci.mysql.models.ChannelSummary]
        """
        return self._channels

    @channels.setter
    def channels(self, channels):
        """
        Sets the channels of this DbSystem.
        A list with a summary of all the Channels attached to the DB System.


        :param channels: The channels of this DbSystem.
        :type: list[oci.mysql.models.ChannelSummary]
        """
        self._channels = channels

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DbSystem.
        The current state of the DB System.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DbSystem.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbSystem.
        The current state of the DB System.


        :param lifecycle_state: The lifecycle_state of this DbSystem.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DbSystem.
        Additional information about the current lifecycleState.


        :return: The lifecycle_details of this DbSystem.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DbSystem.
        Additional information about the current lifecycleState.


        :param lifecycle_details: The lifecycle_details of this DbSystem.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def maintenance(self):
        """
        **[Required]** Gets the maintenance of this DbSystem.

        :return: The maintenance of this DbSystem.
        :rtype: oci.mysql.models.MaintenanceDetails
        """
        return self._maintenance

    @maintenance.setter
    def maintenance(self, maintenance):
        """
        Sets the maintenance of this DbSystem.

        :param maintenance: The maintenance of this DbSystem.
        :type: oci.mysql.models.MaintenanceDetails
        """
        self._maintenance = maintenance

    @property
    def deletion_policy(self):
        """
        **[Required]** Gets the deletion_policy of this DbSystem.

        :return: The deletion_policy of this DbSystem.
        :rtype: oci.mysql.models.DeletionPolicyDetails
        """
        return self._deletion_policy

    @deletion_policy.setter
    def deletion_policy(self, deletion_policy):
        """
        Sets the deletion_policy of this DbSystem.

        :param deletion_policy: The deletion_policy of this DbSystem.
        :type: oci.mysql.models.DeletionPolicyDetails
        """
        self._deletion_policy = deletion_policy

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbSystem.
        The date and time the DB System was created.


        :return: The time_created of this DbSystem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbSystem.
        The date and time the DB System was created.


        :param time_created: The time_created of this DbSystem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DbSystem.
        The time the DB System was last updated.


        :return: The time_updated of this DbSystem.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DbSystem.
        The time the DB System was last updated.


        :param time_updated: The time_updated of this DbSystem.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DbSystem.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DbSystem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbSystem.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DbSystem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DbSystem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DbSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbSystem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DbSystem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DbSystem.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DbSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DbSystem.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DbSystem.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def crash_recovery(self):
        """
        Gets the crash_recovery of this DbSystem.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The crash_recovery of this DbSystem.
        :rtype: str
        """
        return self._crash_recovery

    @crash_recovery.setter
    def crash_recovery(self, crash_recovery):
        """
        Sets the crash_recovery of this DbSystem.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.


        :param crash_recovery: The crash_recovery of this DbSystem.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(crash_recovery, allowed_values):
            crash_recovery = 'UNKNOWN_ENUM_VALUE'
        self._crash_recovery = crash_recovery

    @property
    def point_in_time_recovery_details(self):
        """
        Gets the point_in_time_recovery_details of this DbSystem.

        :return: The point_in_time_recovery_details of this DbSystem.
        :rtype: oci.mysql.models.PointInTimeRecoveryDetails
        """
        return self._point_in_time_recovery_details

    @point_in_time_recovery_details.setter
    def point_in_time_recovery_details(self, point_in_time_recovery_details):
        """
        Sets the point_in_time_recovery_details of this DbSystem.

        :param point_in_time_recovery_details: The point_in_time_recovery_details of this DbSystem.
        :type: oci.mysql.models.PointInTimeRecoveryDetails
        """
        self._point_in_time_recovery_details = point_in_time_recovery_details

    @property
    def database_management(self):
        """
        Gets the database_management of this DbSystem.
        Whether to enable monitoring via the Database Management service.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_management of this DbSystem.
        :rtype: str
        """
        return self._database_management

    @database_management.setter
    def database_management(self, database_management):
        """
        Sets the database_management of this DbSystem.
        Whether to enable monitoring via the Database Management service.


        :param database_management: The database_management of this DbSystem.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(database_management, allowed_values):
            database_management = 'UNKNOWN_ENUM_VALUE'
        self._database_management = database_management

    @property
    def secure_connections(self):
        """
        Gets the secure_connections of this DbSystem.

        :return: The secure_connections of this DbSystem.
        :rtype: oci.mysql.models.SecureConnectionDetails
        """
        return self._secure_connections

    @secure_connections.setter
    def secure_connections(self, secure_connections):
        """
        Sets the secure_connections of this DbSystem.

        :param secure_connections: The secure_connections of this DbSystem.
        :type: oci.mysql.models.SecureConnectionDetails
        """
        self._secure_connections = secure_connections

    @property
    def encrypt_data(self):
        """
        Gets the encrypt_data of this DbSystem.

        :return: The encrypt_data of this DbSystem.
        :rtype: oci.mysql.models.EncryptDataDetails
        """
        return self._encrypt_data

    @encrypt_data.setter
    def encrypt_data(self, encrypt_data):
        """
        Sets the encrypt_data of this DbSystem.

        :param encrypt_data: The encrypt_data of this DbSystem.
        :type: oci.mysql.models.EncryptDataDetails
        """
        self._encrypt_data = encrypt_data

    @property
    def database_mode(self):
        """
        **[Required]** Gets the database_mode of this DbSystem.
        The database mode indicating the types of statements that are allowed to run in the the DB system.
        This mode applies only to statements run by user connections. Replicated write statements continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE: allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.

        Allowed values for this property are: "READ_WRITE", "READ_ONLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_mode of this DbSystem.
        :rtype: str
        """
        return self._database_mode

    @database_mode.setter
    def database_mode(self, database_mode):
        """
        Sets the database_mode of this DbSystem.
        The database mode indicating the types of statements that are allowed to run in the the DB system.
        This mode applies only to statements run by user connections. Replicated write statements continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE: allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :param database_mode: The database_mode of this DbSystem.
        :type: str
        """
        allowed_values = ["READ_WRITE", "READ_ONLY"]
        if not value_allowed_none_or_none_sentinel(database_mode, allowed_values):
            database_mode = 'UNKNOWN_ENUM_VALUE'
        self._database_mode = database_mode

    @property
    def access_mode(self):
        """
        **[Required]** Gets the access_mode of this DbSystem.
        The access mode indicating if the database access is unrestricted (to all MySQL user accounts),
        or restricted (to only certain users with specific privileges):
         - UNRESTRICTED: the access to the database is not restricted;
         - RESTRICTED: access allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode

        Allowed values for this property are: "UNRESTRICTED", "RESTRICTED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The access_mode of this DbSystem.
        :rtype: str
        """
        return self._access_mode

    @access_mode.setter
    def access_mode(self, access_mode):
        """
        Sets the access_mode of this DbSystem.
        The access mode indicating if the database access is unrestricted (to all MySQL user accounts),
        or restricted (to only certain users with specific privileges):
         - UNRESTRICTED: the access to the database is not restricted;
         - RESTRICTED: access allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :param access_mode: The access_mode of this DbSystem.
        :type: str
        """
        allowed_values = ["UNRESTRICTED", "RESTRICTED"]
        if not value_allowed_none_or_none_sentinel(access_mode, allowed_values):
            access_mode = 'UNKNOWN_ENUM_VALUE'
        self._access_mode = access_mode

    @property
    def customer_contacts(self):
        """
        Gets the customer_contacts of this DbSystem.
        The list of customer email addresses that receive information from Oracle about the specified OCI DB System resource.
        Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.
        Up to 10 email addresses can be added to the customer contacts for a DB System.


        :return: The customer_contacts of this DbSystem.
        :rtype: list[oci.mysql.models.CustomerContact]
        """
        return self._customer_contacts

    @customer_contacts.setter
    def customer_contacts(self, customer_contacts):
        """
        Sets the customer_contacts of this DbSystem.
        The list of customer email addresses that receive information from Oracle about the specified OCI DB System resource.
        Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.
        Up to 10 email addresses can be added to the customer contacts for a DB System.


        :param customer_contacts: The customer_contacts of this DbSystem.
        :type: list[oci.mysql.models.CustomerContact]
        """
        self._customer_contacts = customer_contacts

    @property
    def read_endpoint(self):
        """
        Gets the read_endpoint of this DbSystem.

        :return: The read_endpoint of this DbSystem.
        :rtype: oci.mysql.models.ReadEndpointDetails
        """
        return self._read_endpoint

    @read_endpoint.setter
    def read_endpoint(self, read_endpoint):
        """
        Sets the read_endpoint of this DbSystem.

        :param read_endpoint: The read_endpoint of this DbSystem.
        :type: oci.mysql.models.ReadEndpointDetails
        """
        self._read_endpoint = read_endpoint

    @property
    def telemetry_configuration(self):
        """
        Gets the telemetry_configuration of this DbSystem.

        :return: The telemetry_configuration of this DbSystem.
        :rtype: oci.mysql.models.TelemetryConfigurationDetails
        """
        return self._telemetry_configuration

    @telemetry_configuration.setter
    def telemetry_configuration(self, telemetry_configuration):
        """
        Sets the telemetry_configuration of this DbSystem.

        :param telemetry_configuration: The telemetry_configuration of this DbSystem.
        :type: oci.mysql.models.TelemetryConfigurationDetails
        """
        self._telemetry_configuration = telemetry_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
