# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemStatus(object):
    """
    Runtime status summary of a DbSystem, aggregating information about availability and operational indicators.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_system_id:
            The value to assign to the db_system_id property of this DbSystemStatus.
        :type db_system_id: str

        :param time_created:
            The value to assign to the time_created property of this DbSystemStatus.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DbSystemStatus.
        :type time_updated: datetime

        :param db_system_status_result:
            The value to assign to the db_system_status_result property of this DbSystemStatus.
        :type db_system_status_result: oci.mysql.models.DbSystemStatusResult

        """
        self.swagger_types = {
            'db_system_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'db_system_status_result': 'DbSystemStatusResult'
        }
        self.attribute_map = {
            'db_system_id': 'dbSystemId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'db_system_status_result': 'dbSystemStatusResult'
        }
        self._db_system_id = None
        self._time_created = None
        self._time_updated = None
        self._db_system_status_result = None

    @property
    def db_system_id(self):
        """
        **[Required]** Gets the db_system_id of this DbSystemStatus.
        The OCID of the DB System for which the status is gathered.


        :return: The db_system_id of this DbSystemStatus.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this DbSystemStatus.
        The OCID of the DB System for which the status is gathered.


        :param db_system_id: The db_system_id of this DbSystemStatus.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbSystemStatus.
        The date and time that the Work Request to generate the DB System status was issued,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this DbSystemStatus.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbSystemStatus.
        The date and time that the Work Request to generate the DB System status was issued,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this DbSystemStatus.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DbSystemStatus.
        The date and time that the DB System status was generated,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this DbSystemStatus.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DbSystemStatus.
        The date and time that the DB System status was generated,
        as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this DbSystemStatus.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def db_system_status_result(self):
        """
        Gets the db_system_status_result of this DbSystemStatus.

        :return: The db_system_status_result of this DbSystemStatus.
        :rtype: oci.mysql.models.DbSystemStatusResult
        """
        return self._db_system_status_result

    @db_system_status_result.setter
    def db_system_status_result(self, db_system_status_result):
        """
        Sets the db_system_status_result of this DbSystemStatus.

        :param db_system_status_result: The db_system_status_result of this DbSystemStatus.
        :type: oci.mysql.models.DbSystemStatusResult
        """
        self._db_system_status_result = db_system_status_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
