# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LoggingDestinationConfiguration(object):
    """
    Configuration parameters for a given destination.
    """

    #: A constant which can be used with the destination property of a LoggingDestinationConfiguration.
    #: This constant has a value of "LOG_ANALYTICS"
    DESTINATION_LOG_ANALYTICS = "LOG_ANALYTICS"

    #: A constant which can be used with the destination property of a LoggingDestinationConfiguration.
    #: This constant has a value of "OPEN_TELEMETRY"
    DESTINATION_OPEN_TELEMETRY = "OPEN_TELEMETRY"

    #: A constant which can be used with the log_types property of a LoggingDestinationConfiguration.
    #: This constant has a value of "ERROR_LOG"
    LOG_TYPES_ERROR_LOG = "ERROR_LOG"

    #: A constant which can be used with the log_types property of a LoggingDestinationConfiguration.
    #: This constant has a value of "GENERAL_LOG"
    LOG_TYPES_GENERAL_LOG = "GENERAL_LOG"

    #: A constant which can be used with the log_types property of a LoggingDestinationConfiguration.
    #: This constant has a value of "SLOW_QUERY_LOG"
    LOG_TYPES_SLOW_QUERY_LOG = "SLOW_QUERY_LOG"

    #: A constant which can be used with the log_types property of a LoggingDestinationConfiguration.
    #: This constant has a value of "AUDIT_LOG"
    LOG_TYPES_AUDIT_LOG = "AUDIT_LOG"

    def __init__(self, **kwargs):
        """
        Initializes a new LoggingDestinationConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param destination:
            The value to assign to the destination property of this LoggingDestinationConfiguration.
            Allowed values for this property are: "LOG_ANALYTICS", "OPEN_TELEMETRY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type destination: str

        :param destination_configurations:
            The value to assign to the destination_configurations property of this LoggingDestinationConfiguration.
        :type destination_configurations: list[oci.mysql.models.DestinationConfiguration]

        :param log_types:
            The value to assign to the log_types property of this LoggingDestinationConfiguration.
            Allowed values for items in this list are: "ERROR_LOG", "GENERAL_LOG", "SLOW_QUERY_LOG", "AUDIT_LOG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type log_types: list[str]

        """
        self.swagger_types = {
            'destination': 'str',
            'destination_configurations': 'list[DestinationConfiguration]',
            'log_types': 'list[str]'
        }
        self.attribute_map = {
            'destination': 'destination',
            'destination_configurations': 'destinationConfigurations',
            'log_types': 'logTypes'
        }
        self._destination = None
        self._destination_configurations = None
        self._log_types = None

    @property
    def destination(self):
        """
        **[Required]** Gets the destination of this LoggingDestinationConfiguration.
        Type of destination where MySQL telemetry is exposed to.

        Allowed values for this property are: "LOG_ANALYTICS", "OPEN_TELEMETRY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The destination of this LoggingDestinationConfiguration.
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this LoggingDestinationConfiguration.
        Type of destination where MySQL telemetry is exposed to.


        :param destination: The destination of this LoggingDestinationConfiguration.
        :type: str
        """
        allowed_values = ["LOG_ANALYTICS", "OPEN_TELEMETRY"]
        if not value_allowed_none_or_none_sentinel(destination, allowed_values):
            destination = 'UNKNOWN_ENUM_VALUE'
        self._destination = destination

    @property
    def destination_configurations(self):
        """
        **[Required]** Gets the destination_configurations of this LoggingDestinationConfiguration.
        List of configuration variables for a given destination type.


        :return: The destination_configurations of this LoggingDestinationConfiguration.
        :rtype: list[oci.mysql.models.DestinationConfiguration]
        """
        return self._destination_configurations

    @destination_configurations.setter
    def destination_configurations(self, destination_configurations):
        """
        Sets the destination_configurations of this LoggingDestinationConfiguration.
        List of configuration variables for a given destination type.


        :param destination_configurations: The destination_configurations of this LoggingDestinationConfiguration.
        :type: list[oci.mysql.models.DestinationConfiguration]
        """
        self._destination_configurations = destination_configurations

    @property
    def log_types(self):
        """
        **[Required]** Gets the log_types of this LoggingDestinationConfiguration.
        List of MySQL telemetry types that can be exposed on a telemetry destination

        Allowed values for items in this list are: "ERROR_LOG", "GENERAL_LOG", "SLOW_QUERY_LOG", "AUDIT_LOG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The log_types of this LoggingDestinationConfiguration.
        :rtype: list[str]
        """
        return self._log_types

    @log_types.setter
    def log_types(self, log_types):
        """
        Sets the log_types of this LoggingDestinationConfiguration.
        List of MySQL telemetry types that can be exposed on a telemetry destination


        :param log_types: The log_types of this LoggingDestinationConfiguration.
        :type: list[str]
        """
        allowed_values = ["ERROR_LOG", "GENERAL_LOG", "SLOW_QUERY_LOG", "AUDIT_LOG"]
        if log_types:
            log_types[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in log_types]
        self._log_types = log_types

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
