# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicaOverrides(object):
    """
    By default a read replica inherits the MySQL version, shape, and configuration of the source DB system.
    If you want to override any of these, provide values in the properties, mysqlVersion, shapeName,
    and configurationId. If you set a property value to \"\", then the value is inherited from its
    source DB system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicaOverrides object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mysql_version:
            The value to assign to the mysql_version property of this ReplicaOverrides.
        :type mysql_version: str

        :param shape_name:
            The value to assign to the shape_name property of this ReplicaOverrides.
        :type shape_name: str

        :param configuration_id:
            The value to assign to the configuration_id property of this ReplicaOverrides.
        :type configuration_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this ReplicaOverrides.
        :type nsg_ids: list[str]

        :param security_attributes:
            The value to assign to the security_attributes property of this ReplicaOverrides.
        :type security_attributes: dict(str, dict(str, object))

        :param telemetry_configuration:
            The value to assign to the telemetry_configuration property of this ReplicaOverrides.
        :type telemetry_configuration: oci.mysql.models.TelemetryConfigurationDetails

        """
        self.swagger_types = {
            'mysql_version': 'str',
            'shape_name': 'str',
            'configuration_id': 'str',
            'nsg_ids': 'list[str]',
            'security_attributes': 'dict(str, dict(str, object))',
            'telemetry_configuration': 'TelemetryConfigurationDetails'
        }
        self.attribute_map = {
            'mysql_version': 'mysqlVersion',
            'shape_name': 'shapeName',
            'configuration_id': 'configurationId',
            'nsg_ids': 'nsgIds',
            'security_attributes': 'securityAttributes',
            'telemetry_configuration': 'telemetryConfiguration'
        }
        self._mysql_version = None
        self._shape_name = None
        self._configuration_id = None
        self._nsg_ids = None
        self._security_attributes = None
        self._telemetry_configuration = None

    @property
    def mysql_version(self):
        """
        Gets the mysql_version of this ReplicaOverrides.
        The MySQL version to be used by the read replica.


        :return: The mysql_version of this ReplicaOverrides.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this ReplicaOverrides.
        The MySQL version to be used by the read replica.


        :param mysql_version: The mysql_version of this ReplicaOverrides.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def shape_name(self):
        """
        Gets the shape_name of this ReplicaOverrides.
        The shape to be used by the read replica. The shape determines the resources allocated:
        CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.
        To get a list of shapes, use the :func:`list_shapes` operation.


        :return: The shape_name of this ReplicaOverrides.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this ReplicaOverrides.
        The shape to be used by the read replica. The shape determines the resources allocated:
        CPU cores and memory for VM shapes, CPU cores, memory and storage for non-VM (bare metal) shapes.
        To get a list of shapes, use the :func:`list_shapes` operation.


        :param shape_name: The shape_name of this ReplicaOverrides.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this ReplicaOverrides.
        The OCID of the Configuration to be used by the read replica.


        :return: The configuration_id of this ReplicaOverrides.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this ReplicaOverrides.
        The OCID of the Configuration to be used by the read replica.


        :param configuration_id: The configuration_id of this ReplicaOverrides.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this ReplicaOverrides.
        Network Security Group OCIDs used for the VNIC attachment.


        :return: The nsg_ids of this ReplicaOverrides.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this ReplicaOverrides.
        Network Security Group OCIDs used for the VNIC attachment.


        :param nsg_ids: The nsg_ids of this ReplicaOverrides.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this ReplicaOverrides.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `ZPR Artifacts`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm


        :return: The security_attributes of this ReplicaOverrides.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this ReplicaOverrides.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `ZPR Artifacts`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm


        :param security_attributes: The security_attributes of this ReplicaOverrides.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def telemetry_configuration(self):
        """
        Gets the telemetry_configuration of this ReplicaOverrides.

        :return: The telemetry_configuration of this ReplicaOverrides.
        :rtype: oci.mysql.models.TelemetryConfigurationDetails
        """
        return self._telemetry_configuration

    @telemetry_configuration.setter
    def telemetry_configuration(self, telemetry_configuration):
        """
        Sets the telemetry_configuration of this ReplicaOverrides.

        :param telemetry_configuration: The telemetry_configuration of this ReplicaOverrides.
        :type: oci.mysql.models.TelemetryConfigurationDetails
        """
        self._telemetry_configuration = telemetry_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
