# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateClusterDetails(object):
    """
    The Cluster information to be updated.

    **Important:** Only the `displayName`, `freeFormTags`, and `definedTags` attributes
    affect the existing Cluster. Changing the other attributes affects the `Cluster` object, but not
    the VMware environment currently running on that Cluster. Those other attributes are used
    by the Oracle Cloud VMware Solution *only* for new ESXi hosts that you add to this
    Cluster in the future with :func:`create_esxi_host`.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateClusterDetails.
        :type display_name: str

        :param network_configuration:
            The value to assign to the network_configuration property of this UpdateClusterDetails.
        :type network_configuration: oci.ocvp.models.NetworkConfiguration

        :param vmware_software_version:
            The value to assign to the vmware_software_version property of this UpdateClusterDetails.
        :type vmware_software_version: str

        :param esxi_software_version:
            The value to assign to the esxi_software_version property of this UpdateClusterDetails.
        :type esxi_software_version: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'network_configuration': 'NetworkConfiguration',
            'vmware_software_version': 'str',
            'esxi_software_version': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'network_configuration': 'networkConfiguration',
            'vmware_software_version': 'vmwareSoftwareVersion',
            'esxi_software_version': 'esxiSoftwareVersion',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._network_configuration = None
        self._vmware_software_version = None
        self._esxi_software_version = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateClusterDetails.
        The `OCID`__ of the Cluster.
        Cluster name requirements are 1-22 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The display_name of this UpdateClusterDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateClusterDetails.
        The `OCID`__ of the Cluster.
        Cluster name requirements are 1-22 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param display_name: The display_name of this UpdateClusterDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def network_configuration(self):
        """
        Gets the network_configuration of this UpdateClusterDetails.

        :return: The network_configuration of this UpdateClusterDetails.
        :rtype: oci.ocvp.models.NetworkConfiguration
        """
        return self._network_configuration

    @network_configuration.setter
    def network_configuration(self, network_configuration):
        """
        Sets the network_configuration of this UpdateClusterDetails.

        :param network_configuration: The network_configuration of this UpdateClusterDetails.
        :type: oci.ocvp.models.NetworkConfiguration
        """
        self._network_configuration = network_configuration

    @property
    def vmware_software_version(self):
        """
        Gets the vmware_software_version of this UpdateClusterDetails.
        The version of bundled VMware software that the Oracle Cloud VMware Solution will
        install on any new ESXi hosts that you add to this Cluster in the future. To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :return: The vmware_software_version of this UpdateClusterDetails.
        :rtype: str
        """
        return self._vmware_software_version

    @vmware_software_version.setter
    def vmware_software_version(self, vmware_software_version):
        """
        Sets the vmware_software_version of this UpdateClusterDetails.
        The version of bundled VMware software that the Oracle Cloud VMware Solution will
        install on any new ESXi hosts that you add to this Cluster in the future. To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :param vmware_software_version: The vmware_software_version of this UpdateClusterDetails.
        :type: str
        """
        self._vmware_software_version = vmware_software_version

    @property
    def esxi_software_version(self):
        """
        Gets the esxi_software_version of this UpdateClusterDetails.
        The version of bundled ESXi software that the Oracle Cloud VMware Solution will
        install on any new ESXi hosts that you add to this Cluster in the future unless a specific version is configured on the ESXi level.
        To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :return: The esxi_software_version of this UpdateClusterDetails.
        :rtype: str
        """
        return self._esxi_software_version

    @esxi_software_version.setter
    def esxi_software_version(self, esxi_software_version):
        """
        Sets the esxi_software_version of this UpdateClusterDetails.
        The version of bundled ESXi software that the Oracle Cloud VMware Solution will
        install on any new ESXi hosts that you add to this Cluster in the future unless a specific version is configured on the ESXi level.
        To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :param esxi_software_version: The esxi_software_version of this UpdateClusterDetails.
        :type: str
        """
        self._esxi_software_version = esxi_software_version

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
