# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomerLoggingDetails(object):
    """
    Customer logging configuration
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomerLoggingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param log_retention_days:
            The value to assign to the log_retention_days property of this CustomerLoggingDetails.
        :type log_retention_days: int

        """
        self.swagger_types = {
            'log_retention_days': 'int'
        }
        self.attribute_map = {
            'log_retention_days': 'logRetentionDays'
        }
        self._log_retention_days = None

    @property
    def log_retention_days(self):
        """
        **[Required]** Gets the log_retention_days of this CustomerLoggingDetails.
        the age of an index after which the index will get deleted by ISM policy


        :return: The log_retention_days of this CustomerLoggingDetails.
        :rtype: int
        """
        return self._log_retention_days

    @log_retention_days.setter
    def log_retention_days(self, log_retention_days):
        """
        Sets the log_retention_days of this CustomerLoggingDetails.
        the age of an index after which the index will get deleted by ISM policy


        :param log_retention_days: The log_retention_days of this CustomerLoggingDetails.
        :type: int
        """
        self._log_retention_days = log_retention_days

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
