# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceNotificationResponse(object):
    """
    Response for request to send customer maintenance notification.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceNotificationResponse object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param message:
            The value to assign to the message property of this MaintenanceNotificationResponse.
        :type message: str

        :param failed_notifications:
            The value to assign to the failed_notifications property of this MaintenanceNotificationResponse.
        :type failed_notifications: list[oci.opensearch.models.MaintenanceNotificationFailure]

        """
        self.swagger_types = {
            'message': 'str',
            'failed_notifications': 'list[MaintenanceNotificationFailure]'
        }
        self.attribute_map = {
            'message': 'message',
            'failed_notifications': 'failedNotifications'
        }
        self._message = None
        self._failed_notifications = None

    @property
    def message(self):
        """
        **[Required]** Gets the message of this MaintenanceNotificationResponse.
        Response message for the maintenance notification request


        :return: The message of this MaintenanceNotificationResponse.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this MaintenanceNotificationResponse.
        Response message for the maintenance notification request


        :param message: The message of this MaintenanceNotificationResponse.
        :type: str
        """
        self._message = message

    @property
    def failed_notifications(self):
        """
        Gets the failed_notifications of this MaintenanceNotificationResponse.
        List of failed maintenance notifications


        :return: The failed_notifications of this MaintenanceNotificationResponse.
        :rtype: list[oci.opensearch.models.MaintenanceNotificationFailure]
        """
        return self._failed_notifications

    @failed_notifications.setter
    def failed_notifications(self, failed_notifications):
        """
        Sets the failed_notifications of this MaintenanceNotificationResponse.
        List of failed maintenance notifications


        :param failed_notifications: The failed_notifications of this MaintenanceNotificationResponse.
        :type: list[oci.opensearch.models.MaintenanceNotificationFailure]
        """
        self._failed_notifications = failed_notifications

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
