# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .create_database_insight_details import CreateDatabaseInsightDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMacsManagedAutonomousDatabaseInsightDetails(CreateDatabaseInsightDetails):
    """
    The information about database to be analyzed.
    """

    #: A constant which can be used with the deployment_type property of a CreateMacsManagedAutonomousDatabaseInsightDetails.
    #: This constant has a value of "EXACC"
    DEPLOYMENT_TYPE_EXACC = "EXACC"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMacsManagedAutonomousDatabaseInsightDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.CreateMacsManagedAutonomousDatabaseInsightDetails.entity_source` attribute
        of this class is ``MACS_MANAGED_AUTONOMOUS_DATABASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_source:
            The value to assign to the entity_source property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
            Allowed values for this property are: "EM_MANAGED_EXTERNAL_DATABASE", "PE_COMANAGED_DATABASE", "MDS_MYSQL_DATABASE_SYSTEM", "EXTERNAL_MYSQL_DATABASE_SYSTEM", "MACS_MANAGED_CLOUD_DATABASE", "MACS_MANAGED_AUTONOMOUS_DATABASE"
        :type entity_source: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param database_id:
            The value to assign to the database_id property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type database_id: str

        :param management_agent_id:
            The value to assign to the management_agent_id property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type management_agent_id: str

        :param connection_details:
            The value to assign to the connection_details property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type connection_details: oci.opsi.models.ConnectionDetails

        :param connection_credential_details:
            The value to assign to the connection_credential_details property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type connection_credential_details: oci.opsi.models.CredentialDetails

        :param database_resource_type:
            The value to assign to the database_resource_type property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type database_resource_type: str

        :param deployment_type:
            The value to assign to the deployment_type property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
            Allowed values for this property are: "EXACC"
        :type deployment_type: str

        :param system_tags:
            The value to assign to the system_tags property of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'entity_source': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'database_id': 'str',
            'management_agent_id': 'str',
            'connection_details': 'ConnectionDetails',
            'connection_credential_details': 'CredentialDetails',
            'database_resource_type': 'str',
            'deployment_type': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'entity_source': 'entitySource',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'database_id': 'databaseId',
            'management_agent_id': 'managementAgentId',
            'connection_details': 'connectionDetails',
            'connection_credential_details': 'connectionCredentialDetails',
            'database_resource_type': 'databaseResourceType',
            'deployment_type': 'deploymentType',
            'system_tags': 'systemTags'
        }
        self._entity_source = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._database_id = None
        self._management_agent_id = None
        self._connection_details = None
        self._connection_credential_details = None
        self._database_resource_type = None
        self._deployment_type = None
        self._system_tags = None
        self._entity_source = 'MACS_MANAGED_AUTONOMOUS_DATABASE'

    @property
    def database_id(self):
        """
        **[Required]** Gets the database_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The database_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param database_id: The database_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: str
        """
        self._database_id = database_id

    @property
    def management_agent_id(self):
        """
        **[Required]** Gets the management_agent_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        The `OCID`__ of the Management Agent

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The management_agent_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        The `OCID`__ of the Management Agent

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param management_agent_id: The management_agent_id of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def connection_details(self):
        """
        **[Required]** Gets the connection_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.

        :return: The connection_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: oci.opsi.models.ConnectionDetails
        """
        return self._connection_details

    @connection_details.setter
    def connection_details(self, connection_details):
        """
        Sets the connection_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.

        :param connection_details: The connection_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: oci.opsi.models.ConnectionDetails
        """
        self._connection_details = connection_details

    @property
    def connection_credential_details(self):
        """
        **[Required]** Gets the connection_credential_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.

        :return: The connection_credential_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: oci.opsi.models.CredentialDetails
        """
        return self._connection_credential_details

    @connection_credential_details.setter
    def connection_credential_details(self, connection_credential_details):
        """
        Sets the connection_credential_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.

        :param connection_credential_details: The connection_credential_details of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: oci.opsi.models.CredentialDetails
        """
        self._connection_credential_details = connection_credential_details

    @property
    def database_resource_type(self):
        """
        **[Required]** Gets the database_resource_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        OCI database resource type


        :return: The database_resource_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: str
        """
        return self._database_resource_type

    @database_resource_type.setter
    def database_resource_type(self, database_resource_type):
        """
        Sets the database_resource_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        OCI database resource type


        :param database_resource_type: The database_resource_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: str
        """
        self._database_resource_type = database_resource_type

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        Database Deployment Type

        Allowed values for this property are: "EXACC"


        :return: The deployment_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        Database Deployment Type


        :param deployment_type: The deployment_type of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: str
        """
        allowed_values = ["EXACC"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `deployment_type`, must be None or one of {allowed_values}"
            )
        self._deployment_type = deployment_type

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CreateMacsManagedAutonomousDatabaseInsightDetails.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
