# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpsiDataObjectSupportedQueryParam(object):
    """
    Details of query parameter supported by an OPSI data object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OpsiDataObjectSupportedQueryParam object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this OpsiDataObjectSupportedQueryParam.
        :type name: str

        :param description:
            The value to assign to the description property of this OpsiDataObjectSupportedQueryParam.
        :type description: str

        :param data_type:
            The value to assign to the data_type property of this OpsiDataObjectSupportedQueryParam.
        :type data_type: str

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'data_type': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'data_type': 'dataType'
        }
        self._name = None
        self._description = None
        self._data_type = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this OpsiDataObjectSupportedQueryParam.
        Name of the query parameter.


        :return: The name of this OpsiDataObjectSupportedQueryParam.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OpsiDataObjectSupportedQueryParam.
        Name of the query parameter.


        :param name: The name of this OpsiDataObjectSupportedQueryParam.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this OpsiDataObjectSupportedQueryParam.
        Description of the query parameter.


        :return: The description of this OpsiDataObjectSupportedQueryParam.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OpsiDataObjectSupportedQueryParam.
        Description of the query parameter.


        :param description: The description of this OpsiDataObjectSupportedQueryParam.
        :type: str
        """
        self._description = description

    @property
    def data_type(self):
        """
        Gets the data_type of this OpsiDataObjectSupportedQueryParam.
        Data type of the for the query parameter.


        :return: The data_type of this OpsiDataObjectSupportedQueryParam.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this OpsiDataObjectSupportedQueryParam.
        Data type of the for the query parameter.


        :param data_type: The data_type of this OpsiDataObjectSupportedQueryParam.
        :type: str
        """
        self._data_type = data_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
