# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RebootManagedInstanceGroupDetails(object):
    """
    Provides the information used for the reboot job.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RebootManagedInstanceGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reboot_timeout_in_mins:
            The value to assign to the reboot_timeout_in_mins property of this RebootManagedInstanceGroupDetails.
        :type reboot_timeout_in_mins: int

        :param work_request_details:
            The value to assign to the work_request_details property of this RebootManagedInstanceGroupDetails.
        :type work_request_details: oci.os_management_hub.models.WorkRequestDetails

        """
        self.swagger_types = {
            'reboot_timeout_in_mins': 'int',
            'work_request_details': 'WorkRequestDetails'
        }
        self.attribute_map = {
            'reboot_timeout_in_mins': 'rebootTimeoutInMins',
            'work_request_details': 'workRequestDetails'
        }
        self._reboot_timeout_in_mins = None
        self._work_request_details = None

    @property
    def reboot_timeout_in_mins(self):
        """
        Gets the reboot_timeout_in_mins of this RebootManagedInstanceGroupDetails.
        The number of minutes the service waits for the reboot to complete. If the instances in the group don't reboot
        within this time, the reboot job status is set to failed.


        :return: The reboot_timeout_in_mins of this RebootManagedInstanceGroupDetails.
        :rtype: int
        """
        return self._reboot_timeout_in_mins

    @reboot_timeout_in_mins.setter
    def reboot_timeout_in_mins(self, reboot_timeout_in_mins):
        """
        Sets the reboot_timeout_in_mins of this RebootManagedInstanceGroupDetails.
        The number of minutes the service waits for the reboot to complete. If the instances in the group don't reboot
        within this time, the reboot job status is set to failed.


        :param reboot_timeout_in_mins: The reboot_timeout_in_mins of this RebootManagedInstanceGroupDetails.
        :type: int
        """
        self._reboot_timeout_in_mins = reboot_timeout_in_mins

    @property
    def work_request_details(self):
        """
        Gets the work_request_details of this RebootManagedInstanceGroupDetails.

        :return: The work_request_details of this RebootManagedInstanceGroupDetails.
        :rtype: oci.os_management_hub.models.WorkRequestDetails
        """
        return self._work_request_details

    @work_request_details.setter
    def work_request_details(self, work_request_details):
        """
        Sets the work_request_details of this RebootManagedInstanceGroupDetails.

        :param work_request_details: The work_request_details of this RebootManagedInstanceGroupDetails.
        :type: oci.os_management_hub.models.WorkRequestDetails
        """
        self._work_request_details = work_request_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
