# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDbConfigParams(object):
    """
    Configuration for the PostgreSQL database instance.
    """

    #: A constant which can be used with the apply_config property of a UpdateDbConfigParams.
    #: This constant has a value of "RESTART"
    APPLY_CONFIG_RESTART = "RESTART"

    #: A constant which can be used with the apply_config property of a UpdateDbConfigParams.
    #: This constant has a value of "RELOAD"
    APPLY_CONFIG_RELOAD = "RELOAD"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDbConfigParams object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param apply_config:
            The value to assign to the apply_config property of this UpdateDbConfigParams.
            Allowed values for this property are: "RESTART", "RELOAD"
        :type apply_config: str

        :param config_id:
            The value to assign to the config_id property of this UpdateDbConfigParams.
        :type config_id: str

        """
        self.swagger_types = {
            'apply_config': 'str',
            'config_id': 'str'
        }
        self.attribute_map = {
            'apply_config': 'applyConfig',
            'config_id': 'configId'
        }
        self._apply_config = None
        self._config_id = None

    @property
    def apply_config(self):
        """
        Gets the apply_config of this UpdateDbConfigParams.
        Whether a configuration update requires a restart of the database instance or a reload of the configuration.
        Some configuration changes require a restart of database instances to be applied.

        Allowed values for this property are: "RESTART", "RELOAD"


        :return: The apply_config of this UpdateDbConfigParams.
        :rtype: str
        """
        return self._apply_config

    @apply_config.setter
    def apply_config(self, apply_config):
        """
        Sets the apply_config of this UpdateDbConfigParams.
        Whether a configuration update requires a restart of the database instance or a reload of the configuration.
        Some configuration changes require a restart of database instances to be applied.


        :param apply_config: The apply_config of this UpdateDbConfigParams.
        :type: str
        """
        allowed_values = ["RESTART", "RELOAD"]
        if not value_allowed_none_or_none_sentinel(apply_config, allowed_values):
            raise ValueError(
                f"Invalid value for `apply_config`, must be None or one of {allowed_values}"
            )
        self._apply_config = apply_config

    @property
    def config_id(self):
        """
        **[Required]** Gets the config_id of this UpdateDbConfigParams.
        The `OCID`__ of the configuration.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The config_id of this UpdateDbConfigParams.
        :rtype: str
        """
        return self._config_id

    @config_id.setter
    def config_id(self, config_id):
        """
        Sets the config_id of this UpdateDbConfigParams.
        The `OCID`__ of the configuration.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param config_id: The config_id of this UpdateDbConfigParams.
        :type: str
        """
        self._config_id = config_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
