# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricExtensionQueryProperties(object):
    """
    Collection method and query properties details of metric extension
    """

    #: A constant which can be used with the collection_method property of a MetricExtensionQueryProperties.
    #: This constant has a value of "OS_COMMAND"
    COLLECTION_METHOD_OS_COMMAND = "OS_COMMAND"

    #: A constant which can be used with the collection_method property of a MetricExtensionQueryProperties.
    #: This constant has a value of "SQL"
    COLLECTION_METHOD_SQL = "SQL"

    #: A constant which can be used with the collection_method property of a MetricExtensionQueryProperties.
    #: This constant has a value of "JMX"
    COLLECTION_METHOD_JMX = "JMX"

    #: A constant which can be used with the collection_method property of a MetricExtensionQueryProperties.
    #: This constant has a value of "HTTP"
    COLLECTION_METHOD_HTTP = "HTTP"

    def __init__(self, **kwargs):
        """
        Initializes a new MetricExtensionQueryProperties object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.stack_monitoring.models.OsCommandQueryProperties`
        * :class:`~oci.stack_monitoring.models.SqlQueryProperties`
        * :class:`~oci.stack_monitoring.models.JmxQueryProperties`
        * :class:`~oci.stack_monitoring.models.HttpQueryProperties`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collection_method:
            The value to assign to the collection_method property of this MetricExtensionQueryProperties.
            Allowed values for this property are: "OS_COMMAND", "SQL", "JMX", "HTTP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type collection_method: str

        """
        self.swagger_types = {
            'collection_method': 'str'
        }
        self.attribute_map = {
            'collection_method': 'collectionMethod'
        }
        self._collection_method = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['collectionMethod']

        if type == 'OS_COMMAND':
            return 'OsCommandQueryProperties'

        if type == 'SQL':
            return 'SqlQueryProperties'

        if type == 'JMX':
            return 'JmxQueryProperties'

        if type == 'HTTP':
            return 'HttpQueryProperties'
        else:
            return 'MetricExtensionQueryProperties'

    @property
    def collection_method(self):
        """
        **[Required]** Gets the collection_method of this MetricExtensionQueryProperties.
        Type of possible collection methods.

        Allowed values for this property are: "OS_COMMAND", "SQL", "JMX", "HTTP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The collection_method of this MetricExtensionQueryProperties.
        :rtype: str
        """
        return self._collection_method

    @collection_method.setter
    def collection_method(self, collection_method):
        """
        Sets the collection_method of this MetricExtensionQueryProperties.
        Type of possible collection methods.


        :param collection_method: The collection_method of this MetricExtensionQueryProperties.
        :type: str
        """
        allowed_values = ["OS_COMMAND", "SQL", "JMX", "HTTP"]
        if not value_allowed_none_or_none_sentinel(collection_method, allowed_values):
            collection_method = 'UNKNOWN_ENUM_VALUE'
        self._collection_method = collection_method

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
