# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230401


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssignedSubscriptionLineItemSummary(object):
    """
    Summary of the line item in an assigned subscription.
    """

    #: A constant which can be used with the billing_model property of a AssignedSubscriptionLineItemSummary.
    #: This constant has a value of "COMMITMENT"
    BILLING_MODEL_COMMITMENT = "COMMITMENT"

    #: A constant which can be used with the billing_model property of a AssignedSubscriptionLineItemSummary.
    #: This constant has a value of "PAYGO"
    BILLING_MODEL_PAYGO = "PAYGO"

    #: A constant which can be used with the billing_model property of a AssignedSubscriptionLineItemSummary.
    #: This constant has a value of "PROMOTION"
    BILLING_MODEL_PROMOTION = "PROMOTION"

    def __init__(self, **kwargs):
        """
        Initializes a new AssignedSubscriptionLineItemSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AssignedSubscriptionLineItemSummary.
        :type id: str

        :param product_code:
            The value to assign to the product_code property of this AssignedSubscriptionLineItemSummary.
        :type product_code: str

        :param quantity:
            The value to assign to the quantity property of this AssignedSubscriptionLineItemSummary.
        :type quantity: float

        :param billing_model:
            The value to assign to the billing_model property of this AssignedSubscriptionLineItemSummary.
            Allowed values for this property are: "COMMITMENT", "PAYGO", "PROMOTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type billing_model: str

        :param time_started:
            The value to assign to the time_started property of this AssignedSubscriptionLineItemSummary.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this AssignedSubscriptionLineItemSummary.
        :type time_ended: datetime

        :param system_tags:
            The value to assign to the system_tags property of this AssignedSubscriptionLineItemSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'product_code': 'str',
            'quantity': 'float',
            'billing_model': 'str',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'product_code': 'productCode',
            'quantity': 'quantity',
            'billing_model': 'billingModel',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._product_code = None
        self._quantity = None
        self._billing_model = None
        self._time_started = None
        self._time_ended = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AssignedSubscriptionLineItemSummary.
        Subscription line item identifier.


        :return: The id of this AssignedSubscriptionLineItemSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AssignedSubscriptionLineItemSummary.
        Subscription line item identifier.


        :param id: The id of this AssignedSubscriptionLineItemSummary.
        :type: str
        """
        self._id = id

    @property
    def product_code(self):
        """
        **[Required]** Gets the product_code of this AssignedSubscriptionLineItemSummary.
        Product code.


        :return: The product_code of this AssignedSubscriptionLineItemSummary.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this AssignedSubscriptionLineItemSummary.
        Product code.


        :param product_code: The product_code of this AssignedSubscriptionLineItemSummary.
        :type: str
        """
        self._product_code = product_code

    @property
    def quantity(self):
        """
        **[Required]** Gets the quantity of this AssignedSubscriptionLineItemSummary.
        Product number.


        :return: The quantity of this AssignedSubscriptionLineItemSummary.
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this AssignedSubscriptionLineItemSummary.
        Product number.


        :param quantity: The quantity of this AssignedSubscriptionLineItemSummary.
        :type: float
        """
        self._quantity = quantity

    @property
    def billing_model(self):
        """
        **[Required]** Gets the billing_model of this AssignedSubscriptionLineItemSummary.
        Billing model supported by the associated line item.

        Allowed values for this property are: "COMMITMENT", "PAYGO", "PROMOTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The billing_model of this AssignedSubscriptionLineItemSummary.
        :rtype: str
        """
        return self._billing_model

    @billing_model.setter
    def billing_model(self, billing_model):
        """
        Sets the billing_model of this AssignedSubscriptionLineItemSummary.
        Billing model supported by the associated line item.


        :param billing_model: The billing_model of this AssignedSubscriptionLineItemSummary.
        :type: str
        """
        allowed_values = ["COMMITMENT", "PAYGO", "PROMOTION"]
        if not value_allowed_none_or_none_sentinel(billing_model, allowed_values):
            billing_model = 'UNKNOWN_ENUM_VALUE'
        self._billing_model = billing_model

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this AssignedSubscriptionLineItemSummary.
        The time the subscription item and associated products should start. An RFC 3339 formatted date and time string.


        :return: The time_started of this AssignedSubscriptionLineItemSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this AssignedSubscriptionLineItemSummary.
        The time the subscription item and associated products should start. An RFC 3339 formatted date and time string.


        :param time_started: The time_started of this AssignedSubscriptionLineItemSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        **[Required]** Gets the time_ended of this AssignedSubscriptionLineItemSummary.
        The time the subscription item and associated products should end. An RFC 3339 formatted date and time string.


        :return: The time_ended of this AssignedSubscriptionLineItemSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this AssignedSubscriptionLineItemSummary.
        The time the subscription item and associated products should end. An RFC 3339 formatted date and time string.


        :param time_ended: The time_ended of this AssignedSubscriptionLineItemSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AssignedSubscriptionLineItemSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this AssignedSubscriptionLineItemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AssignedSubscriptionLineItemSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this AssignedSubscriptionLineItemSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
