# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicationTarget(object):
    """
    Details for the target that the source secret will be replicated to.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicationTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_key_id:
            The value to assign to the target_key_id property of this ReplicationTarget.
        :type target_key_id: str

        :param target_region:
            The value to assign to the target_region property of this ReplicationTarget.
        :type target_region: str

        :param target_vault_id:
            The value to assign to the target_vault_id property of this ReplicationTarget.
        :type target_vault_id: str

        """
        self.swagger_types = {
            'target_key_id': 'str',
            'target_region': 'str',
            'target_vault_id': 'str'
        }
        self.attribute_map = {
            'target_key_id': 'targetKeyId',
            'target_region': 'targetRegion',
            'target_vault_id': 'targetVaultId'
        }
        self._target_key_id = None
        self._target_region = None
        self._target_vault_id = None

    @property
    def target_key_id(self):
        """
        **[Required]** Gets the target_key_id of this ReplicationTarget.
        The OCID of the target region KMS key.


        :return: The target_key_id of this ReplicationTarget.
        :rtype: str
        """
        return self._target_key_id

    @target_key_id.setter
    def target_key_id(self, target_key_id):
        """
        Sets the target_key_id of this ReplicationTarget.
        The OCID of the target region KMS key.


        :param target_key_id: The target_key_id of this ReplicationTarget.
        :type: str
        """
        self._target_key_id = target_key_id

    @property
    def target_region(self):
        """
        **[Required]** Gets the target_region of this ReplicationTarget.
        The name of the target's region.


        :return: The target_region of this ReplicationTarget.
        :rtype: str
        """
        return self._target_region

    @target_region.setter
    def target_region(self, target_region):
        """
        Sets the target_region of this ReplicationTarget.
        The name of the target's region.


        :param target_region: The target_region of this ReplicationTarget.
        :type: str
        """
        self._target_region = target_region

    @property
    def target_vault_id(self):
        """
        **[Required]** Gets the target_vault_id of this ReplicationTarget.
        The OCID of the target region's Vault.


        :return: The target_vault_id of this ReplicationTarget.
        :rtype: str
        """
        return self._target_vault_id

    @target_vault_id.setter
    def target_vault_id(self, target_vault_id):
        """
        Sets the target_vault_id of this ReplicationTarget.
        The OCID of the target region's Vault.


        :param target_vault_id: The target_vault_id of this ReplicationTarget.
        :type: str
        """
        self._target_vault_id = target_vault_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
