# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_create_details import DrgAttachmentNetworkCreateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemotePeeringConnectionDrgAttachmentNetworkCreateDetails(DrgAttachmentNetworkCreateDetails):
    """
    RemotePeeringConnectionDrgAttachmentNetworkCreateDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RemotePeeringConnectionDrgAttachmentNetworkCreateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.type` attribute
        of this class is ``REMOTE_PEERING_CONNECTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type compartment_id: str

        :param regional_oci_asn:
            The value to assign to the regional_oci_asn property of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type regional_oci_asn: str

        :param is_global_fast_connect:
            The value to assign to the is_global_fast_connect property of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type is_global_fast_connect: bool

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'regional_oci_asn': 'str',
            'is_global_fast_connect': 'bool'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'regional_oci_asn': 'regionalOciAsn',
            'is_global_fast_connect': 'isGlobalFastConnect'
        }
        self._type = None
        self._id = None
        self._compartment_id = None
        self._regional_oci_asn = None
        self._is_global_fast_connect = None
        self._type = 'REMOTE_PEERING_CONNECTION'

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of compartment that contains the remote peering connection.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of compartment that contains the remote peering connection.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def regional_oci_asn(self):
        """
        Gets the regional_oci_asn of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        The BGP ASN to use for the remote peering connection's route target.


        :return: The regional_oci_asn of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._regional_oci_asn

    @regional_oci_asn.setter
    def regional_oci_asn(self, regional_oci_asn):
        """
        Sets the regional_oci_asn of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        The BGP ASN to use for the remote peering connection's route target.


        :param regional_oci_asn: The regional_oci_asn of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._regional_oci_asn = regional_oci_asn

    @property
    def is_global_fast_connect(self):
        """
        Gets the is_global_fast_connect of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        Whether the RPC attachment is for a GFC DRG, indicating the mpls label should be
        allocated from the VC label range.

        Example: `true`


        :return: The is_global_fast_connect of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :rtype: bool
        """
        return self._is_global_fast_connect

    @is_global_fast_connect.setter
    def is_global_fast_connect(self, is_global_fast_connect):
        """
        Sets the is_global_fast_connect of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        Whether the RPC attachment is for a GFC DRG, indicating the mpls label should be
        allocated from the VC label range.

        Example: `true`


        :param is_global_fast_connect: The is_global_fast_connect of this RemotePeeringConnectionDrgAttachmentNetworkCreateDetails.
        :type: bool
        """
        self._is_global_fast_connect = is_global_fast_connect

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
