# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .security_action import SecurityAction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ZprDeniedSecurityAction(SecurityAction):
    """
    Defines the security action taken on zpr denied traffic.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ZprDeniedSecurityAction object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.ZprDeniedSecurityAction.action` attribute
        of this class is ``ZPR_DENIED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action:
            The value to assign to the action property of this ZprDeniedSecurityAction.
            Allowed values for this property are: "ALLOWED", "DENIED", "ZPR_DENIED", "ZPR_ALLOWED", "ZPR_CIDR_UNSUPPORTED", "ZPR_NSG_UNSUPPORTED", "ZPR_POLICY_NOT_EVALUATED_MISSING_ROUTE", "ZPR_POLICY_NOT_EVALUATED_SL_NSG_DENIED", "ZPR_MISSING_POLICY"
        :type action: str

        :param action_type:
            The value to assign to the action_type property of this ZprDeniedSecurityAction.
            Allowed values for this property are: "EXPLICIT", "IMPLICIT"
        :type action_type: str

        :param zpr_denied_security_action_details:
            The value to assign to the zpr_denied_security_action_details property of this ZprDeniedSecurityAction.
        :type zpr_denied_security_action_details: oci.vn_monitoring.models.ZprDeniedSecurityActionDetails

        """
        self.swagger_types = {
            'action': 'str',
            'action_type': 'str',
            'zpr_denied_security_action_details': 'ZprDeniedSecurityActionDetails'
        }
        self.attribute_map = {
            'action': 'action',
            'action_type': 'actionType',
            'zpr_denied_security_action_details': 'zprDeniedSecurityActionDetails'
        }
        self._action = None
        self._action_type = None
        self._zpr_denied_security_action_details = None
        self._action = 'ZPR_DENIED'

    @property
    def zpr_denied_security_action_details(self):
        """
        Gets the zpr_denied_security_action_details of this ZprDeniedSecurityAction.

        :return: The zpr_denied_security_action_details of this ZprDeniedSecurityAction.
        :rtype: oci.vn_monitoring.models.ZprDeniedSecurityActionDetails
        """
        return self._zpr_denied_security_action_details

    @zpr_denied_security_action_details.setter
    def zpr_denied_security_action_details(self, zpr_denied_security_action_details):
        """
        Sets the zpr_denied_security_action_details of this ZprDeniedSecurityAction.

        :param zpr_denied_security_action_details: The zpr_denied_security_action_details of this ZprDeniedSecurityAction.
        :type: oci.vn_monitoring.models.ZprDeniedSecurityActionDetails
        """
        self._zpr_denied_security_action_details = zpr_denied_security_action_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
