# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateContainerScanRegistryDetails(object):
    """
    Registry information for a container scan target
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateContainerScanRegistryDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.vulnerability_scanning.models.CreateOcirContainerScanRegistryDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CreateContainerScanRegistryDetails.
        :type type: str

        :param url:
            The value to assign to the url property of this CreateContainerScanRegistryDetails.
        :type url: str

        """
        self.swagger_types = {
            'type': 'str',
            'url': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'url': 'url'
        }
        self._type = None
        self._url = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'OCIR':
            return 'CreateOcirContainerScanRegistryDetails'
        else:
            return 'CreateContainerScanRegistryDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateContainerScanRegistryDetails.
        The scan level


        :return: The type of this CreateContainerScanRegistryDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateContainerScanRegistryDetails.
        The scan level


        :param type: The type of this CreateContainerScanRegistryDetails.
        :type: str
        """
        self._type = type

    @property
    def url(self):
        """
        Gets the url of this CreateContainerScanRegistryDetails.
        URL of the registry. Required for non-OCIR registry types (for OCIR registry types, it can be inferred from the tenancy).


        :return: The url of this CreateContainerScanRegistryDetails.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this CreateContainerScanRegistryDetails.
        URL of the registry. Required for non-OCIR registry types (for OCIR registry types, it can be inferred from the tenancy).


        :param url: The url of this CreateContainerScanRegistryDetails.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
