/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.gson;

import com.google.gson.JsonParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

final class Iso8601Utils {
    static final String GMT_ID = "GMT";
    static final TimeZone TIMEZONE_Z = TimeZone.getTimeZone("GMT");

    Iso8601Utils() {
    }

    static String format(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TIMEZONE_Z, Locale.US);
        calendar.setTime(date);
        int capacity = "yyyy-MM-ddThh:mm:ss.sssZ".length();
        StringBuilder formatted = new StringBuilder(capacity);
        Iso8601Utils.padInt(formatted, calendar.get(1), "yyyy".length());
        formatted.append('-');
        Iso8601Utils.padInt(formatted, calendar.get(2) + 1, "MM".length());
        formatted.append('-');
        Iso8601Utils.padInt(formatted, calendar.get(5), "dd".length());
        formatted.append('T');
        Iso8601Utils.padInt(formatted, calendar.get(11), "hh".length());
        formatted.append(':');
        Iso8601Utils.padInt(formatted, calendar.get(12), "mm".length());
        formatted.append(':');
        Iso8601Utils.padInt(formatted, calendar.get(13), "ss".length());
        formatted.append('.');
        Iso8601Utils.padInt(formatted, calendar.get(14), "sss".length());
        formatted.append('Z');
        return formatted.toString();
    }

    static Date parse(String date) throws JsonParseException {
        try {
            TimeZone timezone;
            int offset = 0;
            int year = Iso8601Utils.parseInt(date, offset, offset += 4);
            if (Iso8601Utils.checkOffset(date, offset, '-')) {
                // empty if block
            }
            int month = Iso8601Utils.parseInt(date, ++offset, offset += 2);
            if (Iso8601Utils.checkOffset(date, offset, '-')) {
                // empty if block
            }
            int day = Iso8601Utils.parseInt(date, ++offset, offset += 2);
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            boolean hasT = Iso8601Utils.checkOffset(date, offset, 'T');
            if (!hasT && date.length() <= offset) {
                GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
                return calendar.getTime();
            }
            if (hasT) {
                char c;
                hour = Iso8601Utils.parseInt(date, ++offset, offset += 2);
                if (Iso8601Utils.checkOffset(date, offset, ':')) {
                    // empty if block
                }
                minutes = Iso8601Utils.parseInt(date, ++offset, offset += 2);
                if (Iso8601Utils.checkOffset(date, offset, ':')) {
                    ++offset;
                }
                if (date.length() > offset && (c = date.charAt(offset)) != 'Z' && c != '+' && c != '-') {
                    if ((seconds = Iso8601Utils.parseInt(date, offset, offset += 2)) > 59 && seconds < 63) {
                        seconds = 59;
                    }
                    if (Iso8601Utils.checkOffset(date, offset, '.')) {
                        int endOffset = Iso8601Utils.indexOfNonDigit(date, ++offset + 1);
                        int parseEndOffset = Math.min(endOffset, offset + 3);
                        int fraction = Iso8601Utils.parseInt(date, offset, parseEndOffset);
                        milliseconds = (int)(Math.pow(10.0, 3 - (parseEndOffset - offset)) * (double)fraction);
                        offset = endOffset;
                    }
                }
            }
            if (date.length() <= offset) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            char timezoneIndicator = date.charAt(offset);
            if (timezoneIndicator == 'Z') {
                timezone = TIMEZONE_Z;
            } else if (timezoneIndicator == '+' || timezoneIndicator == '-') {
                String timezoneOffset = date.substring(offset);
                if ("+0000".equals(timezoneOffset) || "+00:00".equals(timezoneOffset)) {
                    timezone = TIMEZONE_Z;
                } else {
                    String cleaned;
                    String timezoneId = GMT_ID + timezoneOffset;
                    timezone = TimeZone.getTimeZone(timezoneId);
                    String act = timezone.getID();
                    if (!act.equals(timezoneId) && !(cleaned = act.replace(":", "")).equals(timezoneId)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + timezoneId + " given, resolves to " + timezone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + timezoneIndicator + "'");
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            return calendar.getTime();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new JsonParseException("Not an RFC 3339 date: " + date);
        }
    }

    private static boolean checkOffset(String value, int offset, char expected) {
        return offset < value.length() && value.charAt(offset) == expected;
    }

    private static int parseInt(String value, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i = beginIndex;
        int result = 0;
        if (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result = -digit;
        }
        while (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }

    private static int indexOfNonDigit(String string, int offset) {
        for (int i = offset; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return i;
        }
        return string.length();
    }
}

