/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.activemq;

import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.ext.activemq.ActiveMQAdmin;
import java.net.MalformedURLException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;

public class ActiveMQAdminFactory
implements HermesAdminFactory {
    private static String DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:1616/jmxrmi";
    private String serviceURL;
    private String brokerName = "localhost";
    private String username;
    private String password;

    @Override
    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException, NamingException {
        try {
            return this.createHermesAdmin(hermes);
        }
        catch (MalformedURLException e) {
            throw new HermesException(e);
        }
    }

    private ActiveMQAdmin createHermesAdmin(Hermes hermes) throws MalformedURLException {
        if (this.serviceURL == null) {
            return new ActiveMQAdmin(this, hermes, this.brokerName, new JMXServiceURL(DEFAULT_URL));
        }
        return new ActiveMQAdmin(this, hermes, this.brokerName, new JMXServiceURL(this.serviceURL));
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

