/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix.quickfix;

import hermes.HermesRuntimeException;
import hermes.fix.FIXException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import quickfix.BooleanField;
import quickfix.CharField;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DoubleField;
import quickfix.Field;
import quickfix.FieldNotFound;
import quickfix.IntField;
import quickfix.Message;
import quickfix.StringField;
import quickfix.UtcDateOnlyField;
import quickfix.UtcTimeOnlyField;
import quickfix.UtcTimeStampField;

public class QuickFIXUtils {
    private static Map<String, DataDictionary> dictionaryCache = new HashMap<String, DataDictionary>();

    public static DataDictionary getDictionary(Message message) throws FieldNotFound, FIXException {
        String beginString = message.getHeader().getString(8);
        return QuickFIXUtils.getDictionary(beginString);
    }

    public static DataDictionary getDictionary(String beginString) throws FIXException {
        DataDictionary dictionary = dictionaryCache.get(beginString);
        if (dictionary == null) {
            if (!("FIX.4.0".equals(beginString) || "FIX.4.1".equals(beginString) || "FIX.4.2".equals(beginString) || "FIX.4.3".equals(beginString) || "FIX.4.4".equals(beginString))) {
                throw new HermesRuntimeException("Invalid FIX BeginString: '" + beginString + "'.");
            }
            String dictionaryFileName = "quickfix/" + beginString.replaceAll("\\.", "") + ".xml";
            InputStream ddis = Thread.currentThread().getContextClassLoader().getResourceAsStream(dictionaryFileName);
            if (ddis == null) {
                throw new NullPointerException("Data Dictionary file '" + dictionaryFileName + "' not found at root of CLASSPATH.");
            }
            try {
                dictionary = new DataDictionary(ddis);
                dictionaryCache.put(beginString, dictionary);
            }
            catch (ConfigError configError) {
                throw new HermesRuntimeException("Error loading data dictionary file.", (Exception)((Object)configError));
            }
        }
        return dictionary;
    }

    public static Field getField(Message message, Field field) {
        try {
            if (field instanceof BooleanField) {
                try {
                    return message.getField((BooleanField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((BooleanField)field);
                }
            }
            if (field instanceof CharField) {
                try {
                    return message.getField((CharField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((CharField)field);
                }
            }
            if (field instanceof DoubleField) {
                try {
                    return message.getField((DoubleField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((DoubleField)field);
                }
            }
            if (field instanceof IntField) {
                try {
                    return message.getField((IntField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((IntField)field);
                }
            }
            if (field instanceof StringField) {
                try {
                    return message.getField((StringField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((StringField)field);
                }
            }
            if (field instanceof UtcDateOnlyField) {
                try {
                    return message.getField((UtcDateOnlyField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((UtcDateOnlyField)field);
                }
            }
            if (field instanceof UtcTimeOnlyField) {
                try {
                    return message.getField((UtcTimeOnlyField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((UtcTimeOnlyField)field);
                }
            }
            if (field instanceof UtcTimeStampField) {
                try {
                    return message.getField((UtcTimeStampField)field);
                }
                catch (FieldNotFound ex) {
                    return message.getHeader().getField((UtcTimeStampField)field);
                }
            }
            throw new FieldNotFound(field.getClass().getName());
        }
        catch (FieldNotFound ex) {
            throw new HermesRuntimeException((Exception)((Object)ex));
        }
    }
}

