/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Hermes;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.log4j.Logger;

public class QueueBrowserWithConsumer
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(QueueBrowserWithConsumer.class);
    private Hermes hermes;
    private long timeout;
    private Queue queue;
    private Message currentMessage;
    private String selector;

    public QueueBrowserWithConsumer(Hermes hermes, Queue queue, String selector, long timeout) {
        this.hermes = hermes;
        this.queue = queue;
        this.timeout = timeout;
        this.selector = selector;
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    public Enumeration getEnumeration() throws JMSException {
        return new MyEnumeration();
    }

    public synchronized void close() throws JMSException {
        if (this.hermes != null) {
            if (this.hermes.getTransacted()) {
                this.hermes.rollback();
            }
            this.hermes.close((Destination)this.queue, this.selector);
            this.hermes.close();
            this.hermes = null;
            this.currentMessage = null;
        }
    }

    private class MyEnumeration
    implements Enumeration {
        private MyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            try {
                if (QueueBrowserWithConsumer.this.hermes != null && QueueBrowserWithConsumer.this.currentMessage == null) {
                    if (QueueBrowserWithConsumer.this.selector != null) {
                        QueueBrowserWithConsumer.this.currentMessage = QueueBrowserWithConsumer.this.hermes.receive((Destination)QueueBrowserWithConsumer.this.queue, QueueBrowserWithConsumer.this.timeout);
                    } else {
                        QueueBrowserWithConsumer.this.currentMessage = QueueBrowserWithConsumer.this.hermes.receive((Destination)QueueBrowserWithConsumer.this.queue, QueueBrowserWithConsumer.this.timeout, QueueBrowserWithConsumer.this.selector);
                    }
                }
                return QueueBrowserWithConsumer.this.currentMessage != null;
            }
            catch (JMSException e) {
                log.debug((Object)("receive() threw exception, terminating browse: " + e.getMessage()), (Throwable)e);
                try {
                    QueueBrowserWithConsumer.this.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            try {
                if (QueueBrowserWithConsumer.this.currentMessage != null) {
                    Message message = QueueBrowserWithConsumer.this.currentMessage;
                    return message;
                }
                if (this.hasMoreElements()) {
                    Message message = QueueBrowserWithConsumer.this.currentMessage;
                    return message;
                }
                Object var1_3 = null;
                return var1_3;
            }
            finally {
                QueueBrowserWithConsumer.this.currentMessage = null;
            }
        }
    }
}

