/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.HermesBrowser;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.config.WatchConfig;
import hermes.swing.actions.ActionSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class AddToExistingWatchAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(AddToExistingWatchAction.class);
    private WatchConfig watchConfig;

    public AddToExistingWatchAction(WatchConfig watchConfig) {
        this.watchConfig = watchConfig;
        this.putValue("Name", watchConfig.getId());
        this.putValue("ShortDescription", "Add selection to " + watchConfig.getId());
        this.setEnabled(false);
        this.enableOnBrowserTreeSelection(new Class[]{DestinationConfigTreeNode.class, HermesTreeNode.class}, (Action)this, false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        List<DestinationConfigTreeNode> nodes = HermesBrowser.getBrowser().getBrowserTree().getSelectedDestinationNodes();
        if (nodes.size() > 0) {
            for (DestinationConfigTreeNode node : nodes) {
                HermesBrowser.getBrowser().addOrCreateWatch(this.watchConfig.getId(), HermesBrowser.getBrowser().getBrowserTree().getSelectedHermesNode().getHermes(), node.getConfig());
            }
        } else if (HermesBrowser.getBrowser().getBrowserTree().getSelectedHermesNode() != null && JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Do you want to add all the destinations for this session to the " + this.watchConfig.getId() + " watch window?", "Please confirm", 0) == 0) {
            HermesBrowser.getBrowser().addOrCreateWatch(this.watchConfig.getId(), HermesBrowser.getBrowser().getBrowserTree().getSelectedHermesNode().getHermes());
        }
    }
}

